<?php

namespace App\Filament\Admin\Resources\ReferralInsentiveResource\Pages;

use Filament\Actions;
use App\Models\Client;
use App\Models\CashWalletTransaction;
use Filament\Resources\Pages\CreateRecord;
use App\Filament\Admin\Resources\ReferralInsentiveResource;

class CreateReferralInsentive extends CreateRecord
{
    protected static string $resource = ReferralInsentiveResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    protected function afterCreate()
    {
        
        $this->cashWalletTransactionInsentive($this->record->id, $this->record->referrer_id, $this->record->brik_owner_id, $this->record->amount);

    }

    protected function cashWalletTransactionInsentive($reffer_ins_id, $client_id, $brik_owner_id, $amount)
    {
        $qry = CashWalletTransaction::where('category', 'Referral Insentive')
        ->where('client_id', $client_id)
        ->where('brik_owner_id', $brik_owner_id)
        ->where('referral_insentive_id', $reffer_ins_id);
        
        if($qry->count() > 0){
            
            $upd = CashWalletTransaction::find($qry->first()->id);
            $upd->amount = $amount;
            $upd->signed_amount = $amount;
            $upd->save();

        }else{

            $ins = new CashWalletTransaction;
            $ins->referral_insentive_id = $reffer_ins_id;
            $ins->brik_owner_id = $brik_owner_id;
            $ins->category = 'Referral Insentive';
            $ins->client_id = $client_id;
            $ins->amount = $amount;
            $ins->type = 'Credit';
            $ins->date = date("Y-m-d");
            $ins->signed_amount = $amount;
            $ins->save();

        }

        return;
    }
}
