<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use Filament\Forms\Components\Section;
use App\Models\ReferralInsentiveConfig;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\ReferralinsentiveConfigResource\Pages;
use App\Filament\Admin\Resources\ReferralinsentiveConfigResource\RelationManagers;

class ReferralinsentiveConfigResource extends Resource
{
    protected static ?string $model = ReferralInsentiveConfig::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'MASTER';

    protected static ?string $modelLabel = 'Referral Incentive config';
    
    protected static ?string $pluralModelLabel = 'Referral Incentive config';

    protected static ?string $navigationLabel = 'Referral Incentive config';

    protected static ?int $navigationSort = 12;

    public static function form(Form $form): Form
    {
        return $form
             ->schema([
                Section::make()->schema([
                    TextInput::make('incentive_percent')->required(),
                ])
            ])
            ->columns(1);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([

                TextColumn::make('incentive_percent')
                ->sortable()
                ->searchable(),

            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                   // Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListReferralinsentiveConfigs::route('/'),
            'create' => Pages\CreateReferralinsentiveConfig::route('/create'),
            'edit' => Pages\EditReferralinsentiveConfig::route('/{record}/edit'),
        ];
    }
}
