<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use App\Models\RentPromotionSetting;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Section;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\FileUpload;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\RentPromotionSettingResource\Pages;
use App\Filament\Admin\Resources\RentPromotionSettingResource\RelationManagers;

class RentPromotionSettingResource extends Resource
{
    protected static ?string $model = RentPromotionSetting::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'STAY PORTAL SETTING';

    protected static ?string $modelLabel = 'Promotions';
    
    protected static ?string $pluralModelLabel = 'Promotions';

    protected static ?string $navigationLabel = 'Promotion';

    protected static ?int $navigationSort = 16;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make()->schema([
                    TextInput::make('name')->required(),
                    TextInput::make('text')->required()->maxLength('42')->helperText('Maximum 42 characters are allowed. (including spaces)'),
                    TextInput::make('url')->required(),

                    FileUpload::make('image')
					    ->hint('For Web')
                        ->image()
                        ->required()
                        ->directory('images/rent_portal/promotion'),
						
					FileUpload::make('app_image')
					    ->hint('For Mobile app')
                        ->image()
                        ->required()
                        ->directory('images/rent_portal/promotion'),

                    Toggle::make('active'),
                ])
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                
                TextColumn::make('name')
                ->sortable()
                ->searchable(),

                TextColumn::make('text')
                ->sortable()
                ->searchable(),

                IconColumn::make('active')->boolean(),

            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make(),
                ])
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListRentPromotionSettings::route('/'),
            'create' => Pages\CreateRentPromotionSetting::route('/create'),
            'edit' => Pages\EditRentPromotionSetting::route('/{record}/edit'),
        ];
    }
}
