<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use App\Models\RentTrustedVilla;
use Filament\Resources\Resource;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Section;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Tables\Columns\ImageColumn;
use Filament\Forms\Components\FileUpload;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\RentTrustedVillaResource\Pages;
use App\Filament\Admin\Resources\RentTrustedVillaResource\RelationManagers;

class RentTrustedVillaResource extends Resource
{
    protected static ?string $model = RentTrustedVilla::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'STAY PORTAL SETTING';

    protected static ?string $modelLabel = 'Trusted Villa';
    
    protected static ?string $pluralModelLabel = 'Trusted Villas';

    protected static ?string $navigationLabel = 'Trusted Villa';

    protected static ?int $navigationSort = 17;

    public static function form(Form $form): Form
    {
        return $form
        ->schema([
            Section::make()->schema([
                TextInput::make('heading_text')->maxLength('30')->helperText('Maximum 30 characters are allowed. (including spaces)')->required(),
                TextInput::make('body_text')->required()->maxLength('100')->helperText('Maximum 100 characters are allowed. (including spaces)'),
                
                FileUpload::make('icon')
                    ->image()
                    ->required()
                    ->directory('images/rent_portal/trusted_villas'),

                Toggle::make('active'),
            ])
        ]);

        
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                
                TextColumn::make('heading_text')
                ->sortable()
                ->searchable(),

                TextColumn::make('body_text')
                ->sortable()
                ->searchable(),

                ImageColumn::make('icon'),

                IconColumn::make('active')->boolean(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make(),
                ])
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListRentTrustedVillas::route('/'),
            'create' => Pages\CreateRentTrustedVilla::route('/create'),
            'edit' => Pages\EditRentTrustedVilla::route('/{record}/edit'),
        ];
    }
}
