<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use App\Models\RentalsUnitedConfig;
use Filament\Forms\Components\Section;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\RentalsUnitedConfigResource\Pages;
use App\Filament\Admin\Resources\RentalsUnitedConfigResource\RelationManagers;

class RentalsUnitedConfigResource extends Resource
{
    protected static ?string $model = RentalsUnitedConfig::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'MASTER';

    protected static ?string $modelLabel = 'RU Config';
    
    protected static ?string $pluralModelLabel = 'RU Config';

    protected static ?string $navigationLabel = 'RU Config';

    protected static ?int $navigationSort = 11;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
            Section::make()->schema([
                TextInput::make('username')->required(),
                TextInput::make('password')->required(),
                TextInput::make('owner_id')->readOnly(),
            ])
        ])
        ->columns(3);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([

                TextColumn::make('username')
                ->sortable()
                ->searchable(),

                TextColumn::make('password')
                ->sortable()
                ->searchable(),

                TextColumn::make('owner_id')
                ->sortable()
                ->searchable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListRentalsUnitedConfigs::route('/'),
            'create' => Pages\CreateRentalsUnitedConfig::route('/create'),
            'edit' => Pages\EditRentalsUnitedConfig::route('/{record}/edit'),
        ];
    }
}
