<?php

namespace App\Filament\Admin\Resources\SpvResource\Pages;

use Filament\Actions;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;
use App\Filament\Admin\Resources\SpvResource;

class EditSpv extends EditRecord
{
    protected static string $resource = SpvResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make()
            ->action(function ($record) {
                         
                if ($record->childRecordCounts() > 0 ) {
                    Notification::make()
                        ->danger()
                        ->title('SPV is in use')
                        ->body('Cannot delete this record because related records exist.')
                        ->send();

                        return;
                }

                Notification::make()
                        ->danger()
                        ->title('Deleted')
                        ->body('Deleted SPV record.')
                        ->send();

                $record->delete();
				
				return redirect(SpvResource::getUrl('index')); 
            }),
        ];
    }
}
