<?php

namespace App\Http\Controllers\Api\Booking;


use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\UnitRatingCollection;
use App\Models\BrikUnitRating;
use Illuminate\Support\Facades\Validator;

class CommentController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'brik_unit_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        $units = BrikUnitRating::where('brik_unit_id', $request->brik_unit_id)->with(['client'])->paginate();
        //return response()->json($this->throwSuccessResponse(["data" => $units]));
		
		return response()->json(new UnitRatingCollection($units));
       

    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'rating' => 'required',
            'brik_unit_id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        //$validated = $validator->validated();
        $data = [];

        try {

            $data['client_id'] = $request->user()->id;
            $data['brik_unit_id'] = $request->brik_unit_id;
            $data['rating'] = $request->rating;
            $data['comment'] = $request->comment;

            $rating = BrikUnitRating::create($data);
            return response()->json($this->throwSuccessResponse(["data" => $rating]));
        } catch(\Exception $e){
            return $this->throwFailedResponse($e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $rating = BrikUnitRating::find($id);
        return response()->json($this->throwSuccessResponse(["data" => $rating]));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $validator = Validator::make($request->all(), [
            'rating' => 'required',
            'brik_unit_id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        //$validated = $validator->validated();
        $data = [];

        try {

            $data['client_id'] = $request->user()->id;
            $data['brik_unit_id'] = $request->brik_unit_id;
            $data['rating'] = $request->rating;
            $data['comment'] = $request->comment;

            $rating = BrikUnitRating::find($id);
            $rating->update($data);

            return response()->json($this->throwSuccessResponse(["data" => $rating]));
        } catch(\Exception $e){
            return $this->throwFailedResponse($e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        try {

            $rating = BrikUnitRating::find($id);
            $rating->delete();

            return response()->json($this->throwSuccessResponse(["data" => null]));
        } catch(\Exception $e){
            return $this->throwFailedResponse($e->getMessage());
        }
    }

	public function showall(Request $request)
    {
        $units = BrikUnitRating::with(['client'])->whereRaw('CHAR_LENGTH(comment) > 40')
		            ->orderByRaw('CHAR_LENGTH(comment) DESC')
					->orderBy('rating', 'DESC')->paginate(15);

        return response()->json(new UnitRatingCollection($units));
        //return response()->json($this->throwSuccessResponse(["data" => $units]));

    }
}
