<?php

namespace App\Http\Controllers\Api\Booking;


use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\BookingCoupon;
use Illuminate\Support\Facades\Validator;

class CouponController extends Controller
{

    public function getValidCoupons(Request $request)
    {
		$validator = Validator::make($request->all(), [
            'date' => 'required|date',
            'booking_from_date' => 'required|date',
            'booking_to_date' => 'required|date|after:booking_from_date',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }
		
		$validCoupons = BookingCoupon::where('valid_from','<=', $request->date)->where('valid_to','>=', $request->date)
                        ->where('booking_valid_from','<=', $request->booking_from_date)->where('booking_valid_to','>=', $request->booking_to_date)->where('active', 1)->get();
       
        return response()->json($this->throwSuccessResponse(["data" => $validCoupons]));
    }

    
    
}
