<?php

namespace App\Http\Controllers\Api\Booking;

use App\Models\BrikSpv;
use App\Models\BrikBrik;
use App\Models\BrikUnit;
use Illuminate\Http\Request;
use App\Models\ClientWishlist;
use App\Models\ClientWishlistItem;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\LandingPageResource;
use App\Http\Resources\WishlistItemResource;

class WishlistController extends Controller
{

    public function list(Request $request)
    {
		$wishlist = ClientWishlist::with(['brik_unit','brik_unit.brik','brik_unit.project','brik_unit.project.city'])->where('client_id', $request->user()->id)->get();
        
		return response()->json($this->throwSuccessResponse(["data" => WishlistItemResource::collection($wishlist)]));
    }
    
    

    public function additem(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'brik_unit_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        
        $chk = ClientWishlist::where('client_id', $request->user()->id)->where('brik_unit_id', $request->brik_unit_id);
        if($chk->count() == 0){
            $ins = new ClientWishlist;
            $ins->brik_unit_id = $request->brik_unit_id;
            $ins->client_id = $request->user()->id;
            $ins->save();
        }
            
        return response()->json($this->throwSuccessResponse(["data" => null]));
    }

    public function removeitem(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'brik_unit_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        
        $chk = ClientWishlist::where('client_id', $request->user()->id)->where('brik_unit_id', $request->brik_unit_id);
        if($chk->count() > 0){
           $chk->delete();
        }
            
        return response()->json($this->throwSuccessResponse(["data" => null]));
    }

}
