<?php

namespace App\Http\Controllers\Api\Invest;

use App\Http\Controllers\Controller;
use App\Models\InvestBlog;
use Illuminate\Http\Request;

class BlogController extends Controller
{
    public function showall(Request $request)
    {
        $blogs = InvestBlog::with(['invest_metadata'])->orderByDesc('updated_at')->get();
        return response()->json($this->throwSuccessResponse(["data" => $blogs]));
    }

	public function showdetail(Request $request, $slug)
    {
        $blog = InvestBlog::with(['invest_metadata'])->where('slug', $slug)->first();
        return response()->json($this->throwSuccessResponse(["data" => $blog]));
    }
}
