<?php

namespace App\Http\Controllers\Api\Invest;

use App\Actions\TeleCRM\TeleCRM;
use Illuminate\Http\Request;
use App\Mail\InvestContactForm;
use App\Http\Controllers\Controller;
use App\Mail\InvestBecomeChannelPartnerForm;
use App\Mail\InvestJobApplyForm;
use Illuminate\Support\Facades\Mail;
use App\Models\InvestPropertyBooking;
use App\Mail\InvestFailedPaymentBooking;
use App\Mail\InvestSuccessPaymentBooking;

class InvestEmailsController extends Controller
{
    public $email = 'info@brikitt.com';

    public function contact_us(Request $request)
    {
		//return response()->json($request->all());
		//dd($request);
        //name
        //email
        //phone
        //message
        //city
        //about
        //hear_about_brikitt
        try
        {
          TeleCRM::contact_us($request);
        }catch(\Exception $e){

        }

        Mail::to($this->email)->send(new InvestContactForm($request));
        return response()->json($this->throwSuccessResponse(
            [
                "data" => null
            ]
        ));
    }

    public function become_channel_partner(Request $request)
    {
        $profile = '';
        if($request->hasFile('profile')){
            $profilepath = $request->profile->store('email', 'public');
            $profile = env("APP_URL").'storage/'.$profilepath;
        }

        $pan = '';
        if($request->hasFile('pan')){
            $panpath = $request->pan->store('email', 'public');
            $pan = env("APP_URL").'storage/'.$panpath;
        }

        $aadhaar = '';
        if($request->hasFile('pan')){
            $aadhaarpath = $request->pan->store('email', 'public');
            $aadhaar = env("APP_URL").'storage/'.$aadhaarpath;
        }

        $data = [
            "name" => $request->name,
            "email" => $request->email,
            "phone" => $request->phone,
            "state" => $request->state,
            "city" => $request->city,
            "zip" => $request->zip,
            "about" => $request->about,
            "profile" => $profile,
            "pan" => $pan,
            "aadhaar" => $aadhaar
        ];

        Mail::to($this->email)->send(new InvestBecomeChannelPartnerForm($data));
        return response()->json($this->throwSuccessResponse(
            [
                "data" => null
            ]
        ));
    }

    public function job_apply(Request $request)
    {
        //name
        //email
        //phone
        //city
        //position
        //linkedin
        Mail::to($this->email)->send(new InvestJobApplyForm($request));
        return response()->json($this->throwSuccessResponse(
            [
                "data" => null
            ]
        ));
    }

	public function successInvestBooking(Request $request)
    {
        if($request->id){

            try{
                //$emails = ['info@brikitt.com','accounts@brikitt.com'];
                $emails = ['er.gauravmukherjee@gmail.com'];
                $invest_bookings = InvestPropertyBooking::where('id', $request->id)->get();

                Mail::to($emails)->send(new InvestSuccessPaymentBooking($invest_bookings));
                return response()->json($this->throwSuccessResponse(
                    [
                        "data" => null
                    ]
                ));
            }catch(\Exception $e){
                return response()->json($this->throwFailedResponse('Email send error.'));
            }

        }else{
            return response()->json($this->throwFailedResponse('request id is required.'));
        }

    }

    public function failedInvestBooking(Request $request)
    {
        if($request->id){

            try{
                //$emails = ['info@brikitt.com','accounts@brikitt.com'];
                $emails = ['er.gauravmukherjee@gmail.com'];
                $invest_bookings = InvestPropertyBooking::where('id', $request->id)->get();

                Mail::to($emails)->send(new InvestFailedPaymentBooking($invest_bookings));
                return response()->json($this->throwSuccessResponse(
                    [
                        "data" => null
                    ]
                ));
            }catch(\Exception $e){
                return response()->json($this->throwFailedResponse('Email send error.'));
            }

        }else{
            return response()->json($this->throwFailedResponse('request id is required.'));
        }

    }
}
