<?php

namespace App\Http\Controllers\Api\Invest;

use App\Http\Controllers\Controller;
use App\Http\Resources\InvestLandingPageResource;
use App\Models\BrikProject;
use App\Models\InvestPropertyDetail;
use Illuminate\Http\Request;

class PropertyController extends Controller
{
    public function showall(Request $request)
    {
        $projects = InvestPropertyDetail::with(['project','project.state','project.city'])->get();

       // $projects = BrikProject::select('id','project_name','state_id','city_id')->with(['state','city','investment_detail'])->whereIn('id', $project_ids)->get();

        return response()->json($this->throwSuccessResponse(["data" => InvestLandingPageResource::collection($projects)]));
    }

	public function shownewlylaunched(Request $request)
    {
       // $project_ids = InvestPropertyDetail::where('status', 'Newly Launched')->pluck('brik_project_id')->toArray();

        $projects = InvestPropertyDetail::with(['project','project.state','project.city'])->where('status', 'Newly Launched')->get();

        //$projects = BrikProject::select('id','project_name','invest_description','address','pin','lat','lng')->with(['state','city','investment_detail','investment_detail.amenities'])->whereIn('id', $project_ids)->get();

        return response()->json($this->throwSuccessResponse(["data" => InvestLandingPageResource::collection($projects)]));
    }

	public function showdetail(Request $request, $slug)
    {
		$project = InvestPropertyDetail::with(['project','project.state','project.city','invest_metadata','amenities'])->where('slug', $slug)->first();

        //$projects = BrikProject::select('id','state_id','city_id','project_name','invest_description','address','pin','lat','lng')->with(['state','city','investment_detail','investment_detail.invest_metadata','investment_detail.amenities'])->where('id', $project_id)->first();

        return response()->json($this->throwSuccessResponse(["data" => $project]));
    }
}
