<?php

namespace App\Http\Controllers\Api\Owner;


use App\Models\Spv;
use App\Models\BrikOwner;
use Illuminate\Http\Request;
use App\Models\BrikInstallment;
use App\Models\BrikPaymentmyplan;
use App\Actions\Payment\BookingPayment;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\BrikAnnualMaintenance;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\OwnerDetailPageResource;
use App\Http\Resources\OwnerLandingPageResource;
use App\Http\Resources\OwnerPaymentPlanResource;

class OwnerAnnualMaintanancePaymentController extends Controller
{
    public function show($ownership_id, Request $request)
    {
        $brik_owner = BrikOwner::find($ownership_id);

        if($brik_owner){

               $maintanances = BrikAnnualMaintenance::with('BrikOwner')
                ->where('brik_owner_id', $brik_owner->id)
                ->get();

                return response()->json($this->throwSuccessResponse(
                    ["data" => $maintanances
                ]));
            
            
        }
        
        return response()->json($this->throwSuccessResponse(
            ["data" => null
        ]));
    }

    public function showReminder($ownership_id,Request $request)
    {
        $brik_owner = BrikOwner::find($ownership_id);

        if($brik_owner){

             
                $maintanances = BrikAnnualMaintenance::with('BrikOwner')
                ->where('brik_owner_id', $brik_owner->id)
                ->where('maintenance_paid',0)
                ->get();

                return response()->json($this->throwSuccessResponse(
                    ["data" => $maintanances
                ]));
            
            
        }
        
        return response()->json($this->throwSuccessResponse(
            ["data" => null
        ]));
        
    }

    public function payment(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'maintenance_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }
		
        $pay_order = 'BRIK-AM-'.rand(10000000, 100000000);
        $amc = BrikAnnualMaintenance::with(['BrikOwner','BrikOwner.brik_unit'])->find($request->maintenance_id);
        $amc->pay_order_id = $pay_order;
        $amc->save();

        $spv_id = null;
        if($amc->BrikOwner){
            if($amc->BrikOwner->brik_unit){
                $spv_id = $amc->BrikOwner->brik_unit->spv_id;
            }else{
                return response()->json($this->throwFailedResponse('Brik Unit Record not found!'));
            }
        }else{
            return response()->json($this->throwFailedResponse('Brik Owner Record not found!'));
        }

       
		
        $returnurl = route('maintenance.payment.return').'?order='.$pay_order.'&maintenance_id='.$request->maintenance_id;
		
        $amc = BrikAnnualMaintenance::with(['BrikOwner','BrikOwner.brik_unit'])->find($request->maintenance_id);
		
        // $payment = new SpvPayment($cashfree_app_id, $cashfree_app_secret);
        // $payment->addClientInfo(Auth::user());
        // $payment->addBookingInfo($amc);
        // $payment->addReturnUrl($returnurl);
        // $payment_req = $payment->generateSession();
		
	
		 $payment = new BookingPayment();
         $payment->addClientInfo(Auth::user());
         $payment->addAMCInfo($amc); // If event is booking
         $payment->addReturnUrl($returnurl);
         $payment_req = $payment->generateSession();
		
	

        if($payment_req["cf_order_id"] && $amc->id){

            $upd = BrikAnnualMaintenance::find($amc->id);
            $upd->cf_order_id = $payment_req["cf_order_id"];
            $upd->save();
        }
                
        return response()->json($this->throwSuccessResponse([
            "mode" => 'payment',
            "data" => $payment_req,
        ]));
    }

    // Payment Gateway Endpoint
    public function paymentreturn(Request $request)
    {
        $order_id = $request->order;
        $maintenance_id = $request->maintenance_id;

        $amc = BrikAnnualMaintenance::with(['BrikOwner','BrikOwner.brik_unit'])->find($maintenance_id);
        
        $payment_status = 'ACTIVE';

       $spv_id = null;
        if($amc->BrikOwner){
            if($amc->BrikOwner->brik_unit){
                $spv_id = $amc->BrikOwner->brik_unit->spv_id;
            }else{
                return response()->json($this->throwFailedResponse('Brik Unit Record not found!'));
            }
        }else{
            return response()->json($this->throwFailedResponse('Brik Owner Record not found!'));
        }

        
		
        $payment = new BookingPayment();

        $payment_res = $payment->getOrderInfo($order_id);
		
		if($payment_res["order_status"]){
			
			
            if($payment_res["order_status"] == 'PAID'){

                $payment_status = 'PAID';
				
                BrikAnnualMaintenance::where('id', $maintenance_id)->update([
                    "payment_status" => $payment_status,
                    "maintenance_paid" => 1,
                    "payment_date" => date("Y-m-d"),
                ]);

            }else{

			}

        }

        $redirecturl = env("FRONTEND_APP_URL").'amc-payment-status?amc='.$maintenance_id;

        return Redirect::to($redirecturl);
    }

    public function maintanancePaymentDetails(Request $request)
	{

        $validator = Validator::make($request->all(), [
            'maintenance' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

         $amc = BrikAnnualMaintenance::with(['brikOwner','brikOwner.brik_unit','brikOwner.brik_unit.project', 'brikOwner.brik_unit.brik'])->find($request->maintenance);
        return response()->json($this->throwSuccessResponse(["data" => $amc]));
    }

}
