<?php

namespace App\Http\Controllers\Api\Owner;


use App\Models\BrikOwner;
use Illuminate\Http\Request;
use App\Models\BrikPaymentmyplan;
use App\Http\Controllers\Controller;
use App\Http\Resources\OwnershipResource;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\OwnerDetailPageResource;
use App\Http\Resources\OwnerLandingPageResource;
use App\Http\Resources\OwnerPaymentPlanResource;

class OwnerBrikBuyPaymentController extends Controller
{
    public function show($unit_id, Request $request)
    {
        $brikownerships_ids = BrikOwner::where('brik_unit_id', $unit_id)->where('owner_id', $request->user()->id)->pluck('id')->toArray();
		
        $payment_plans = BrikPaymentmyplan::with('brik_owner','brik_owner.brik_unit','brik_owner.brik_unit.project')
            ->whereIn('brik_owner_id', $brikownerships_ids)->get();
			
            // if(is_null(count($payment_plans) == 0)){
            //     return response()->json($this->throwSuccessResponse(["data" => []]));
            // }
            
        return response()->json($this->throwSuccessResponse(["data" => OwnerPaymentPlanResource::collection($payment_plans)]));
       
       
    }

    public function showReminder($unit_id, Request $request)
    {
        $brikowner = BrikOwner::where('brik_unit_id', $unit_id)->where('owner_id', $request->user()->id)->first();
		
        if($brikowner)
        {
			
            $payment_plan = BrikPaymentmyplan::with('brik_owner','brik_owner.brik_unit','brik_owner.brik_unit.project')->where('brik_owner_id', $brikowner->id)->where('booking_amount_balance','>',0)->first();
            
            if(is_null($payment_plan)){
                return response()->json($this->throwSuccessResponse(["data" => []]));
            }
            
            return response()->json($this->throwSuccessResponse(["data" => new OwnerPaymentPlanResource($payment_plan)]));
        }
        return response()->json($this->throwSuccessResponse(["data" => []]));
        
    }


}
