<?php

namespace App\Http\Controllers\Api\Owner;

use App\Models\BrikOwner;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\CoOwnerResource;
use App\Models\BrikOwnerContactRequest;

class OwnerBrikCoOwnerController extends Controller
{
    
    public function coOwners(Request $request, $unit_id)
    {
       
        $coowners = BrikOwner::with(['owner'])->where('brik_unit_id', $unit_id)
                    ->where('owner_id','!=', $request->user()->id)
					->groupBy('owner_id');
                  
					
		$me = BrikOwner::with(['owner'])->where('brik_unit_id', $unit_id)
                    ->where('owner_id', $request->user()->id)
					->groupBy('owner_id');
                  
				   
		$allcoowners = $coowners->union($me)->get();
        
        return response()->json($this->throwSuccessResponse(["data" => CoOwnerResource::collection($allcoowners)]));
        //return response()->json($this->throwSuccessResponse(["data" => $coowners]));
    }

    public function coOwnerSendRequest(Request $request)
    {
        $sender_owner_id = $request->user()->id;
        $req = BrikOwnerContactRequest::where('sender_owner_id', $sender_owner_id)
        ->where('receiver_owner_id', $request->receiver_owner_id)->first();

        if($req){
             return response()->json($this->throwFailedResponse('Request already registered.'));
        }else{
            $ins = new BrikOwnerContactRequest;
            $ins->sender_owner_id = $sender_owner_id;
            $ins->receiver_owner_id = $request->receiver_owner_id;
            $ins->save();

            return response()->json($this->throwSuccessResponse(["data" => $ins]));
        }
    }

    public function listCoOwnersRequest(Request $request)
    {
        $receiver_owner_id = $request->user()->id;
        $lists = BrikOwnerContactRequest::with(['sender'])->where('receiver_owner_id', $receiver_owner_id)
                ->where('request_status', 0)->get();

        return response()->json($this->throwSuccessResponse(["data" => $lists]));
        
    }

    public function coOwnersRequestApproved($req_id, Request $request)
    {
        $receiver_owner_id = $request->user()->id;
        $req = BrikOwnerContactRequest::find($req_id);
        $req->request_status = 1;
        $req->save();

        return response()->json($this->throwSuccessResponse(["data" => null]));
        
    }

    public function coOwnersRequestDeclined($req_id, Request $request)
    {
        $receiver_owner_id = $request->user()->id;
        $req = BrikOwnerContactRequest::find($req_id);
        $req->request_status = 2;
        $req->save();

        return response()->json($this->throwSuccessResponse(["data" => null]));
        
    }




}
