<?php

namespace App\Http\Controllers\Api\Owner;


use App\Models\Client;
use App\Models\BrikOwner;
use Illuminate\Http\Request;
use App\Models\BookingBooking;
use App\Models\ClientIdDetail;
use App\Models\ClientBankDetail;
use Illuminate\Support\Facades\DB;
use App\Models\ReferralInsentive;
use App\Models\ClientNomineeDetail;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\OwnerDetailPageResource;
use App\Http\Resources\BookingHistoryCollection;
use App\Http\Resources\OwnerLandingPageResource;

class OwnerProfileController extends Controller
{
    public function getProfile(Request $request)
    {
        $client = Client::with(["bank","nominee","identities"])->find($request->user()->id);

        $identities = [];
        foreach($client->identities as $identity){
            $identities[] = [
                "client_identity_id" => $identity->id,
                "document_type" => $identity->document_type,
                "document_no" => $identity->document_no,
                "id_pic_front" => $identity->id_pic_front,
                "id_pic_back" => $identity->id_pic_back,
            ];
        }


		$res = [
            "personal" => [
                "first_name" => $client->first_name,
                "last_name" => $client->last_name,
                "dob" => $client->dob,
                "address" => $client->address,
                "state" => $client->state,
                "city" => $client->city,
                "email" => $client->email,
                "profession" => $client->profession,
                "emergency_phone" => $client->emergency_phone,
                "marital_status" => $client->marital_status,
                "anniversary_date" => $client->anniversary_date,
                "gender" => $client->gender,
                "image" => $client->image,
            ],
            "bank" => [
                "bank" => $client->bank ? $client->bank->bank : null,
                "account_holder_name" => $client->bank ? $client->bank->account_holder_name : null,
                "account_no" => $client->bank ? $client->bank->account_no : null,
                "ifsc" => $client->bank ? $client->bank->ifsc : null,
                "statement" => $client->bank ? $client->bank->statement : null,
            ],
            "nominee" => [
                "name" => $client->nominee ? $client->nominee->name : null,
                "contact_no" => $client->nominee ? $client->nominee->contact_no : null,
                "email" => $client->nominee ? $client->nominee->email : null,
                "relation" => $client->nominee ? $client->nominee->relation : null,
                "aadhaar_no" => $client->nominee ? $client->nominee->aadhaar_no : null,
                "pan_no" => $client->nominee ? $client->nominee->pan_no : null,
                "photo" => $client->nominee ? $client->nominee->photo : null,
            ],
            "identity" => $identities
        ];

        return response()->json($this->throwSuccessResponse(["data" => $res]));
    }

    public function updatePersonalInfo(Request $request)
    {
        $client = Client::find($request->user()->id);
        $client->first_name = $request->first_name;
        $client->last_name = $request->last_name;
        $client->dob = $request->dob;
        $client->address = $request->address;
        $client->state = $request->state;
        $client->city = $request->city;
        $client->email = $request->email;
        $client->profession = $request->profession;
        $client->emergency_phone = $request->emergency_phone;
        $client->marital_status = $request->marital_status;
        $client->anniversary_date = $request->anniversary_date;
        $client->gender = $request->gender;
        $client->save();

        $res = [
                "first_name" => $client->first_name,
                "last_name" => $client->last_name,
                "dob" => $client->dob,
                "address" => $client->address,
                "state" => $client->state,
                "city" => $client->city,
                "email" => $client->email,
                "profession" => $client->profession,
                "emergency_phone" => $client->emergency_phone,
                "marital_status" => $client->marital_status,
                "anniversary_date" => $client->anniversary_date,
                "gender" => $client->gender,
                "image" => $client->image,
                ];


        return response()->json($this->throwSuccessResponse(["data" => $res]));

    }

    public function updateBankInfo(Request $request)
    {
        $cbd = ClientBankDetail::where('client_id', $request->user()->id)->first();

        if($cbd){
            //update
            $qry = ClientBankDetail::find($cbd->id);
        }else{
            //create
            $qry = new ClientBankDetail;
            $qry->client_id = $request->user()->id;
        }

        $qry->bank = $request->bank;
        $qry->account_holder_name = $request->account_holder_name;
        $qry->account_no = $request->account_no;
        $qry->ifsc = $request->ifsc;
        $qry->save();

         $res = [
                "bank" => $qry->bank,
                "account_holder_name" => $qry->account_holder_name,
                "account_no" => $qry->account_no,
                "ifsc" => $qry->ifsc,
                "statement" => $qry->statement,
             ];

        return response()->json($this->throwSuccessResponse(["data" => $res]));

    }

    public function updateNomineeInfo(Request $request)
    {
        $cbd = ClientNomineeDetail::where('client_id', $request->user()->id)->first();

        if($cbd){
            //update
            $qry = ClientNomineeDetail::find($cbd->id);
        }else{
            //create
            $qry = new ClientNomineeDetail;
            $qry->client_id = $request->user()->id;
        }

        $qry->name = $request->name;
        $qry->contact_no = $request->contact_no;
        $qry->email = $request->email;
        $qry->relation = $request->relation;
        $qry->aadhaar_no = $request->aadhaar_no;
        $qry->pan_no = $request->pan_no;
        $qry->save();

        $res = [
                "name" => $qry->name,
                "contact_no" => $qry->contact_no,
                "email" => $qry->email,
                "relation" => $qry->relation,
                "aadhaar_no" => $qry->aadhaar_no,
                "pan_no" => $qry->pan_no,
             ];

        return response()->json($this->throwSuccessResponse(["data" => $res]));
    }

    public function updateIdInfo(Request $request)
    {
         $validator = Validator::make($request->all(), [
            'document_type' => 'required',
            'id_pic_front' => 'sometimes|nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'id_pic_back' => 'sometimes|nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        $front_image_path = null;
        if($request->hasFile('id_pic_front')) {

            $imageName = time().'.'.$request->id_pic_front->extension();
            $front_image_path = $request->id_pic_front->store('images/clients/id', 'public');

        }

        $back_image_path = null;
        if($request->hasFile('id_pic_back')) {

            $imageName = time().'.'.$request->id_pic_back->extension();
            $back_image_path = $request->id_pic_back->store('images/clients/id', 'public');

        }

        $cbd = ClientIdDetail::where('client_id', $request->user()->id)
                ->where('document_type', $request->document_type)
                ->first();

        if($cbd){
            //update
            $qry = ClientIdDetail::find($cbd->id);
        }else{
            //create
            $qry = new ClientIdDetail;
            $qry->client_id = $request->user()->id;
            $qry->document_type = $request->document_type;
        }


        $qry->document_no = $request->document_no;
        $qry->id_pic_front = $front_image_path;
        $qry->id_pic_back = $back_image_path;
        $qry->save();

        // $res = [
        //         "document_type" => $qry->document_type,
        //         "document_no" => $qry->document_no,
        //         "id_pic_front" => $qry->id_pic_front,
        //         "id_pic_back" => $qry->id_pic_back,
        //      ];

        $ids = ClientIdDetail::where('client_id', $request->user()->id)->get();

        $res = [];

        foreach($ids as $qry){
            $res[] = [
                "client_identity_id" => $qry->id,
                "document_type" => $qry->document_type,
                "document_no" => $qry->document_no,
                "id_pic_front" => $qry->id_pic_front,
                "id_pic_back" => $qry->id_pic_back,
             ];
        }

        return response()->json($this->throwSuccessResponse(["data" => $res]));


    }

    public function removeIdInfo(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'client_identity_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($this->throwValidationFailedResponse($this->modifyValidationErrors($validator->messages()->get('*'))));
        }

        $qry = ClientIdDetail::find($request->client_identity_id);
        $qry->delete();

        $ids = ClientIdDetail::where('client_id', $request->user()->id)->get();

        $res = [];

        foreach($ids as $qry){
            $res[] = [
                "client_identity_id" => $qry->id,
                "document_type" => $qry->document_type,
                "document_no" => $qry->document_no,
                "id_pic_front" => $qry->id_pic_front,
                "id_pic_back" => $qry->id_pic_back,
             ];
        }

        return response()->json($this->throwSuccessResponse(["data" => $res]));

    }

    public function updateBankStatement(Request $request)
    {
        $request->validate([
            'bank_statement' => 'required|mimes:pdf',
        ]);

        $cbd = ClientBankDetail::where('client_id', $request->user()->id)->first();

        if($cbd){
            //update
            $qry = ClientBankDetail::find($cbd->id);
        }else{
            //create
            $qry = new ClientBankDetail;
            $qry->client_id = $request->user()->id;
        }

        $path = $request->bank_statement->store('images/clients/bank_statement', 'public');


        $qry->statement = $path;

        $qry->save();

        return response()->json($this->throwSuccessResponse(["data" => ["path" => $path]]));
    }

    public function updateNomineePhoto(Request $request)
    {
        $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        $cbd = ClientNomineeDetail::where('client_id', $request->user()->id)->first();

        if($cbd){
            //update
            $qry = ClientNomineeDetail::find($cbd->id);
        }else{
            //create
            $qry = new ClientNomineeDetail;
            $qry->client_id = $request->user()->id;
        }

        $path = $request->image->store('images/clients/nominee', 'public');


        $qry->photo = $path;

        $qry->save();

        return response()->json($this->throwSuccessResponse(["data" => ["path" => $path]]));
    }

    public function removeNomineePhoto(Request $request)
    {
        $cbd = ClientNomineeDetail::where('client_id', $request->user()->id)->first();

        if($cbd){

            $qry = ClientNomineeDetail::find($cbd->id);
            $qry->photo = null;
            $qry->save();
        }

        return response()->json($this->throwSuccessResponse(["data" => null]));
    }

	public function referralDiscountearningLog(Request $request)
    {
        $insentives = ReferralInsentive::with(['brik_owner','brik_owner.owner'])->where('referrer_id', $request->user()->id)->orderBy('created_at', 'DESC')->get();

        return response()->json($this->throwSuccessResponse(["data" => $insentives]));
    }

}
