<?php

namespace App\Http\Controllers\Api\Owner;


use App\Models\BrikOwner;
use Illuminate\Http\Request;
use App\Models\BookingBooking;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\OwnerDetailPageResource;
use App\Http\Resources\BookingHistoryCollection;
use App\Http\Resources\OwnerLandingPageResource;

class OwnerScheduleController extends Controller
{
    public function allbookedDates($unit_id)
    {
       
        $q = "WITH RECURSIVE
                cte AS ( SELECT `date_blocked_from`, `date_blocked_to`, `date_blocked_from` single_date 
                        FROM booking_booking_requests WHERE booking_status = 'Active' AND `brik_unit_id` = {$unit_id} 
                        UNION ALL
                        SELECT `date_blocked_from`, `date_blocked_to`, single_date + INTERVAL 1 DAY
                        FROM cte
                        WHERE single_date < `date_blocked_to` )

                SELECT DISTINCT single_date
                FROM cte
                ORDER BY 1;";

        $res = collect(DB::select($q))->pluck('single_date')->toArray();
        
        return response()->json($this->throwSuccessResponse(["data" => ["blocked_dates" => $res]]));
    }

    public function pastbookedDates($unit_id)
    {
        $fromdate = date("Y-m-d");
        $q = "WITH RECURSIVE
                cte AS ( SELECT `date_blocked_from`, `date_blocked_to`, `date_blocked_from` single_date 
                        FROM booking_booking_requests WHERE booking_status = 'Active' AND `brik_unit_id` = {$unit_id} AND  `date_blocked_from` <= '{$fromdate}'
                        UNION ALL
                        SELECT `date_blocked_from`, `date_blocked_to`, single_date + INTERVAL 1 DAY
                        FROM cte
                        WHERE single_date < `date_blocked_to` )

                SELECT DISTINCT single_date
                FROM cte
                ORDER BY 1;";

        $res = collect(DB::select($q))->pluck('single_date')->toArray();
        
        return response()->json($this->throwSuccessResponse(["data" => ["blocked_dates" => $res]]));
    }

    public function upcomingbookedDates($unit_id)
    {
        $fromdate = date("Y-m-d");
        $q = "WITH RECURSIVE
                cte AS ( SELECT `date_blocked_from`, `date_blocked_to`, `date_blocked_from` single_date 
                        FROM booking_booking_requests WHERE booking_status = 'Active' AND `brik_unit_id` = {$unit_id} AND  `date_blocked_from` > '{$fromdate}'
                        UNION ALL
                        SELECT `date_blocked_from`, `date_blocked_to`, single_date + INTERVAL 1 DAY
                        FROM cte
                        WHERE single_date < `date_blocked_to` )

                SELECT DISTINCT single_date
                FROM cte
                ORDER BY 1;";

        $res = collect(DB::select($q))->pluck('single_date')->toArray();
        
        return response()->json($this->throwSuccessResponse(["data" => ["blocked_dates" => $res]]));
    }

    
    public function bookingAllHistory(Request $request, $unit_id){
		
        $ownership = BrikOwner::where('owner_id', $request->user()->id)->where('brik_unit_id', $unit_id)->count();

        if($ownership == 0){
            return response()->json($this->throwFailedResponse('Owner not owned this unit.'));
        }

        $bookings = BookingBooking::with(['client'])
                ->where('brik_unit_id', $unit_id)
                ->where('booking_status', 'Active')
                ->paginate(20);

        return response()->json(["data" => $bookings]);

    }

    public function bookingPastHistory(Request $request, $unit_id){

        $ownership = BrikOwner::where('owner_id', $request->user()->id)->where('brik_unit_id', $unit_id)->count();

        if($ownership == 0){
            return response()->json($this->throwFailedResponse('Owner not owned this unit.'));
        }

        $bookings = BookingBooking::with(['client'])
        ->where('brik_unit_id', $unit_id)
        ->where('date_check_in','<=', date("Y-m-d"))
        ->where('booking_status', 'Active')
        ->paginate(20);

        return response()->json(["data" => $bookings]);
	}

    public function bookingUpcomingHistory(Request $request, $unit_id){

        $ownership = BrikOwner::where('owner_id', $request->user()->id)->where('brik_unit_id', $unit_id)->count();

        if($ownership == 0){
            return response()->json($this->throwFailedResponse('Owner not owned this unit.'));
        }

        $bookings = BookingBooking::with(['client'])
        ->where('brik_unit_id', $unit_id)
        ->where('date_check_in','>', date("Y-m-d"))
        ->where('booking_status', 'Active')
        ->paginate(20);

        return response()->json(["data" => $bookings]);
	}

    //Not used now
    
    // public function list(Request $request, $unit_id, $monthyear)
    // {
    //     $fromdate = $monthyear.'-01';
    //     $todate = $monthyear.date("-t", strtotime($fromdate));

    //     $ownership = BrikOwner::where('owner_id', $request->user()->id)->where('brik_unit_id', $unit_id)->count();

    //     if($ownership == 0){
    //         return response()->json($this->throwFailedResponse('Owner not owned this unit.'));
    //     }

    //     $bookings = BookingBooking::where('brik_unit_id', $unit_id)
    //                 ->where(function ($query) use($fromdate, $todate) {
    //                         $query->where('date_check_in','>=' , $fromdate)
    //                             ->where('date_check_out', '<=', $todate);
    //                         })->paginate(20);
                            
    //     return response()->json(new BookingHistoryCollection($bookings));
       
    // }

}
