<?php

namespace App\Http\Controllers\Api;

use App\Actions\RU\RU;
use App\Models\Client;
use App\Models\TempOtp;
use App\Actions\Sms\SMS;
use App\Models\BrikUnit;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Actions\RU\RURequest;
use App\Actions\RU\XmlToJson;
use App\Models\BookingBooking;
use App\Actions\RU\RentalsUnited;
use App\Models\RentalsUnitedConfig;
use App\Http\Controllers\Controller;
use App\Actions\RU\RentalsUnitedBase;
use App\Models\BookingBookingRequest;
use Illuminate\Support\Facades\Validator;
use App\Mail\RentalBookingSuccessToAdmin;
use App\Actions\Sms\Whatsapp as SmsWhatsapp;
use App\Models\BookingBookingDetail;

class TestController extends Controller
{

	public function demomail()
    {

        $bookingRequest = BookingBookingRequest::with(['bookings'])->find(1);
        $booking_guest = BookingBooking::where('booking_request_id', 1)->first();
        $guest = new Client;
        if($booking_guest){
            $guest = Client::find($booking_guest->client_id);
        }

        Mail::to(['er.gauravmukherjee@gmail.com', 'dev.gauravmukherjee@gmail.com'])->send(new RentalBookingSuccessToAdmin($bookingRequest, $guest));

        dd("Email is sent successfully.");
    }
	
    public function canceltest()
    {
		
        $booking = BookingBooking::whereNotNull('ru_reservation_id')->first();
       
        $ru = new RU;
        $ru->cancelBooking($booking);
    }
    public function owners()
    {
        $ru = new RU;

        // $config = RentalsUnitedConfig::find(1);
        // $api = new RURequest($config);

        // $api->callGetOwners();

        //$ru = new RentalsUnitedBase();
        //$owners = $ru->getOwners();


        // if($owners->Pull_ListAllOwners_RS->Status->value == 'Success'){
        //     foreach($owners->Pull_ListAllOwners_RS->Owners as $owner){
        //         $ruq = RentalsUnitedConfig::find(1);
        //         $ruq->owner_id = $owner->OwnerID;
        //         $ruq->save();
        //     }
        // }

        
        //$ownerJson = json_encode($ownerRaw);
        //$owners = json_decode($ownerJson);

        

        //dd( $owners->Owners->Owner->@attributes );

        


    }

    public function checkAvailibility(){
        $ru = new RU;
        $is_booking_date_available = $ru->isBookingDatesBlocked(3981547, '2025-05-10','2025-05-12');
        dd($is_booking_date_available);
    }

    public function book(){
        $ru = new RU;
        $ru->booking('booking_object');
    }

    public function reservation()
    {
        $ru = new RU;
        $reservations = $ru->getReservations('2025-05-01 00:00:00', '2025-12-01 00:00:00');

       foreach($reservations as $reservation)
       {
          
            $chk = BookingBooking::where('ru_reservation_id', $reservation['ReservationID']);
            if($chk->count() == 0){
                
               $brik_unit = BrikUnit::where('ru_property_id', $reservation['StayInfos']['StayInfo']['PropertyID'])->first();

               if($brik_unit){

                    $isBookingExist = $this->isBookingExist(
                                        $brik_unit->id, 
                                        $reservation['StayInfos']['StayInfo']['DateFrom'], 
                                        $reservation['StayInfos']['StayInfo']['DateTo'],
                                      );

                    if(!$isBookingExist){
                        // Here Booking needs to create
                        
                        $brik_unit_id = $brik_unit->id;
                        
                        $this->booking(
                            $brik_unit_id, 
                            $reservation['StayInfos']['StayInfo']['DateFrom'], 
                            $reservation['StayInfos']['StayInfo']['DateTo'], 
                            $reservation['StayInfos']['StayInfo']['Costs'], 
                            $reservation['StayInfos']['StayInfo']['NumberOfGuests'],  
                            $reservation['CustomerInfo'],
                        );


                    }
                 
               }

            }
       }

    }

    public function isBookingExist($brik_unit_id, $date_blocked_from, $date_blocked_to)
    {
        return BookingBookingRequest::where('brik_unit_id', $brik_unit_id)->where('booking_status', 'Active')
                    ->where(function ($query) use ($date_blocked_from, $date_blocked_to) {
                        $query->whereBetween('date_blocked_from', [$date_blocked_from, $date_blocked_to])
                            ->orWhereBetween('date_blocked_to', [$date_blocked_from, $date_blocked_to])
                            ->orWhere(function ($q) use ($date_blocked_from, $date_blocked_to) {
                                $q->where('date_blocked_from', '<=', $date_blocked_from)
                                  ->where('date_blocked_to', '>=', $date_blocked_to);
                            });
                    })->exists();

    }

    public function addClient($customerInfo)
    {

        $first_name = is_array($customerInfo["Name"]) ? null : $customerInfo["Name"];
        $last_name = is_array($customerInfo["SurName"]) ? null : $customerInfo["SurName"];
        $email = is_array($customerInfo["Email"]) ? null : $customerInfo["Email"];
        $phone = is_array($customerInfo["Phone"]) ? ( is_array($customerInfo["MobilePhone"]) ? null : $customerInfo["MobilePhone"] )  : $customerInfo["Phone"];
        $address = is_array($customerInfo["Address"]) ? null : $customerInfo["Address"];
        $pin = is_array($customerInfo["ZipCode"]) ? null : $customerInfo["ZipCode"];

        if($phone){

            $client = Client::where('mobile', $phone)->first();
            if($client){

                return $client->id;

            }else{

                $cins = new Client;
                $cins->mobile = $phone;
                $cins->first_name = $first_name;
                $cins->last_name = $last_name;
                $cins->email = $email;
                $cins->address = $address;
                $cins->pin = $pin;
                $cins->save();

                return $cins->id;
            }
            
        }


    }

    public function bookingRequest($brik_unit_id, $date_check_in, $date_check_out)
    {
        $date_blocked_from = $date_check_in;
        $date_blocked_to = date("Y-m-d",strtotime("-1 day ".$date_check_out));

        $booking_request = new BookingBookingRequest;
        $booking_request->brik_unit_id = $brik_unit_id;
        $booking_request->booking_from_date = $date_check_in;
        $booking_request->booking_to_date = $date_check_out;
        $booking_request->date_blocked_from = $date_blocked_from;
        $booking_request->date_blocked_to = $date_blocked_to;
        $booking_request->booking_status = 'Active';
        $booking_request->ru_sync_required = 0;
        $booking_request->save();

        return $booking_request;
    }

    public function booking($brik_unit_id, $date_check_in, $date_check_out, $costs, $guest, $customerInfo)
    {

        $booking_request = $this->bookingRequest($brik_unit_id, $date_check_in, $date_check_out);
        $client_id = $this->addClient($customerInfo);
        $nights = $this->countDays($date_check_in, $date_check_out);
        $pricing = $this->ru_pricing($nights, $costs);

        $payBooking = new BookingBooking;
        $payBooking->booking_request_id = $booking_request->id;
        $payBooking->date_check_in = $date_check_in;
        $payBooking->date_check_out = $date_check_out;
        //$payBooking->price_per_night = $request->payment_booking["price_per_night"];
        $payBooking->booking_night_counts = $nights;
        $payBooking->booking_cost_in_rupee = $pricing["payable_amount"];
        $payBooking->brik_coupon_id = null;
        $payBooking->coupon_amount = null;
        $payBooking->payable_amount = $pricing["payable_amount"];
        $payBooking->gst_amount = $pricing["gst"];
        $payBooking->net_payable_amount = $pricing["net_payable_amount"];
        $payBooking->pay_by = 'Amount';
        $payBooking->adult = $guest;
        $payBooking->children = 0;
        $payBooking->infants = 0;
        $payBooking->pets = 0;
        $payBooking->booking_status = 'Active';
        $payBooking->pay_order_id = null;
        $payBooking->brik_unit_id = $brik_unit_id;
        $payBooking->client_id = $client_id;
        $payBooking->booking_from = 'RU';
        $payBooking->save();

        $payBookingDetail = new BookingBookingDetail;
        $payBookingDetail->booking_id = $payBooking->id;
        $payBookingDetail->from_date = $date_check_in;
        $payBookingDetail->to_date = $date_check_out;
        $payBookingDetail->price = $pricing["price_per_night"];
        $payBookingDetail->nights = $nights;
        $payBookingDetail->booking_price = $pricing["payable_amount"];
        $payBookingDetail->save();


    }

    protected function countDays($fromdate,$todate)
    {
        $from = strtotime($fromdate);
        $to = strtotime($todate);
        $diff = round(($to - $from) / (60 * 60 * 24));

        if($from === $to){
            return 1;
        }else{
            return (int)$diff;
        }
    }

    protected function ru_pricing($nights, $costs)
    {
       $net_payable_amount = $costs["RUPrice"];
       $gst = $costs["RUPrice"] * (18 / 100);
       $payable_amount = $net_payable_amount - $gst;
       $price_per_night = $payable_amount / $nights;

       return [
            "price_per_night" => $price_per_night,
            "payable_amount" => $payable_amount,
            "gst" => $gst,
            "net_payable_amount" => $net_payable_amount,
       ];
        
    }
    
}
