<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use App\Models\ClientWishlist;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Resources\Json\JsonResource;

class BookingHistoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        
        
        return [
            'booking_id' => $this->id,
            'price_per_night' => $this->price_per_night,
            'coins_per_night' => $this->coins_per_night,
            'date_check_in' => $this->date_check_in,
            'date_check_out' => $this->date_check_out,
            'booking_night_counts' => $this->booking_night_counts,
            'booking_cost_in_rupee' => $this->booking_cost_in_rupee,
            'booking_cost_in_coin' => $this->booking_cost_in_coin,
			'brik_coupon_id' => $this->brik_coupon_id,
            'coupon_amount' => $this->coupon_amount,
			'payable_amount' => $this->payable_amount,
			'gst_amount' => $this->gst_amount,
			'net_payable_amount' => $this->net_payable_amount,
            'paid_amount' => $this->paid_amount,
            'balance_amount' => $this->balance_amount,
            'pay_by' => $this->pay_by,
            'adult' => $this->adult,
			'children' => $this->children,
            'infants' => $this->infants,
            'pets' => $this->pets,
            'booking_status' => $this->booking_status,
            'order_id' => $this->order_id,
            'cf_order_id' => $this->cf_order_id,
            'cf_order_status' => $this->cf_order_status,
            // 'brik_unit_id' => $this->brik_unit_id,
            // 'brik_unit' =>  new LandingPageResource($this->brik_unit),
            'client_id' => $this->client_id,
        ];
    }
}
