<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use App\Models\ClientWishlist;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Resources\Json\JsonResource;

class BookingRequestResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        
        
        return [
            'booking_request_id' => $this->id,
            'date_check_in' => $this->booking_from_date,
            'date_check_out' => $this->booking_to_date,
            'bookings' => BookingHistoryResource::collection($this->bookings),
            'brik_unit_id' => $this->brik_unit_id,
            'brik_unit' =>  new LandingPageResource($this->brik_unit),
        ];
    }
}
