<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use App\Models\ClientWishlist;
use App\Models\RuPropertyPrice;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Resources\Json\JsonResource;

class LandingPageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        
        $is_liked = false;
        if(Auth::guard('api')->check()){
           
            if(ClientWishlist::where('client_id', Auth::guard('api')->user()->id)->where('brik_unit_id', $this->id)->count() > 0){
                $is_liked = true;
            }
        }

        $price_per_night = null;
       
        $ru_price = RuPropertyPrice::where('brik_unit_id', $this->id)
		->where('from_date','<=', date("Y-m-d"))->where('to_date', '>=', date("Y-m-d"));

		if($ru_price->count() > 0){
			$price_per_night = $ru_price->first()->price;
		}
            
        
        return [
            'brik_unit_id' => $this->id,
            'brik_unit_name' => $this->booking_portal_display_name,
            'cover_image' => $this->rent_cover_image ? $this->rent_cover_image : $this->brik->brik_rent_cover_image,
			'gallery_images' => $this->rent_gallery_images ? $this->rent_gallery_images : $this->brik->brik_rent_gallery_images,
			'adults_capacity' => $this->brik->adults_capacity,
			'children_capacity' => $this->brik->children_capacity,
			'bedroom' => $this->brik->bedroom,
            'price_per_night' => is_null($price_per_night) ? $this->per_night_inr : $price_per_night,
            'city' => $this->project->city->name,
			'icon_name' => $this->project->city->icon_name, 
            'rating' => $this->rating,
            'like' => $is_liked,
        ];
    }
}
