<?php

namespace App\Http\Resources;

use App\Models\BrikOwner;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OwnerDetailPageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
		
        return [
            'brik_owner_id' => $this->id,
            'brik_unit_id' => $this->brik_unit->id,
            'brik_unit_name' => $this->brik_unit->unit_name,
            'brik_value' => $this->brik_unit->brik_value,
            'ownership' => $this->ownership,
            'ownership_outof' => $this->ownership_outof,
            'ownership_string' => $this->ownership_string,
            'invested_amount' => $this->invested_amount,
            'description' => $this->brik_unit->project->invest_description,
            'project_name' => $this->brik_unit->project->project_name,
            'unit_number' => $this->brik_unit->unit_number,
			'possession' => $this->brik_unit->possession == 'Possession Date' ? date("M d, Y", strtotime($this->brik_unit->date_of_possession)) : $this->brik_unit->possession,
            'property_view' => $this->brik_unit->property_view,
            'property_type' => $this->brik_unit->brik->propertyType->name,
            'cover_image' => $this->brik_unit->invest_cover_image ? $this->brik_unit->invest_cover_image : $this->brik_unit->brik->brik_invest_cover_image,
			'gallery_images' => $this->brik_unit->invest_gallery_images ? $this->brik_unit->invest_gallery_images : $this->brik_unit->brik->brik_invest_gallery_images,
            'amenities' => $this->brik_unit->brik->amenities,
			'adults_capacity' => $this->brik_unit->brik->adults_capacity,
			'children_capacity' => $this->brik_unit->brik->children_capacity,
			'bedroom' => $this->brik_unit->brik->bedroom,
            'bathroom' => $this->brik_unit->brik->bathroom,
            'accomadation' => $this->brik_unit->brik->accomadation,
            'property_area' => $this->brik_unit->brik->property_area,
            'address' => $this->brik_unit->project->address,
            'state' => $this->brik_unit->project->state->name,
            'city' => $this->brik_unit->project->city->name,
            'pin' => $this->brik_unit->project->pin,
            'lat' => $this->brik_unit->project->lat,
            'lng' => $this->brik_unit->project->lng,
            'spv' => $this->brik_unit->spv,
            'brik_manager' => $this->brik_unit->project->projectManager,
            'referrer' => $this->referrer,
			'is_live' => $this->brik_unit->invest_active,
        ];
    }
}
