<?php

namespace App\Http\Resources;

use App\Models\BrikInstallment;
use App\Models\BrikOwner;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OwnerPaymentPlanResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $total_paid_amt = 0;
		$total_due_amt = 0;

		$sum_installment_paid = BrikInstallment::where('payment_plan_id', $this->id)->where('installment_paid', 1)->sum('installment_amount');

		

		$total_paid_amt = $this->booking_amount + $sum_installment_paid;
		$total_due_amt = $this->invested_amount - $total_paid_amt;

		    return [
			   
				"payment_plan_id" => $this->id,
				"ownership_id" => $this->brik_owner->id,
				"project_name" => $this->brik_owner->brik_unit->project->project_name,
				"unit_name" => $this->brik_owner->brik_unit->unit_name,
				"unit_number" => $this->brik_owner->brik_unit->unit_number,
				"brik_value" => $this->brik_owner->brik_unit->brik_value,
				"invested_amount" => $this->invested_amount,
				"brik_count" => $this->brik_count,
				"booking_amount" => $this->booking_amount,
				"booking_amount_paid" => $this->booking_amount_paid,
				"gst_paid" => $this->gst_paid,
				"payment_date" => $this->payment_date,
				"booking_amount_balance" => $this->booking_amount_balance,
				"discount_booking" => $this->discount_booking,
				"discount_brik" => $this->discount_brik,
				'payment_plan_id' => $this->id,
				'brik_owner_id' => $this->brik_owner_id,
				"spv_id" => $this->brik_owner->brik_unit->spv_id,
				"total_paid_amt" => $total_paid_amt,
				"total_due_amt" => $total_due_amt,
				
			];
		
    }
}
