<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use App\Models\ClientWishlist;
use App\Models\RuPropertyPrice;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Resources\Json\JsonResource;

class UnitRatingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        $client_name = $this->client_name ? $this->client_name : 'Guest Experience';
        return [
            'id' => $this->id,
            'client_id' => $this->client_id,
            'brik_unit_id' => $this->brik_unit_id,
			'rating' => $this->rating,
			'comment' => $this->comment,
			'created_at' => $this->created_at,
			'updated_at' => $this->updated_at,
            'client' => $this->client ? $this->client : ["first_name" => $client_name],
        ];
    }
}
