<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class WishlistItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $is_liked = true;
        return [
           
            'brik_unit_id' => $this->brik_unit->id,
            'brik_unit_name' => $this->brik_unit->booking_portal_display_name,
            'cover_image' => $this->brik_unit->rent_cover_image ? $this->brik_unit->rent_cover_image : $this->brik_unit->brik->brik_rent_cover_image,
			'gallery_images' => $this->brik_unit->rent_gallery_images ? $this->brik_unit->rent_gallery_images : $this->brik_unit->brik->brik_rent_gallery_images,
			'adults_capacity' => $this->brik_unit->brik->adults_capacity,
			'children_capacity' => $this->brik_unit->brik->children_capacity,
			'bedroom' => $this->brik_unit->brik->bedroom,
            'price_per_night' => $this->brik_unit->brik->per_night_inr,
            'city' => $this->brik_unit->project->city->name,
            'rating' => $this->brik_unit->rating,
            'like' => $is_liked,
        ];
    }
}
