<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BookingBookingRequest extends Model
{
    protected $fillable = ['brik_unit_id','date_check_in','date_check_out','date_blocked_from','date_blocked_to','booking_status'];

    public function brik_unit()
    {
        return $this->belongsTo(BrikUnit::class, 'brik_unit_id');
    }

    public function bookings()
    {
        return $this->hasMany(BookingBooking::class, 'booking_request_id');
    }
}
