<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BrikAnnualMaintenance extends Model
{
    protected $fillable = ['maintenance_year', 'cost_per_year',	'due_date',	'annual_maintenance_referal_discount',	'waived_off', 'maintenance_paid', 'payment_date', 'payment_receipt', 'payable_amount', 'brik_owner_id'];

    public function BrikOwner()
    {
        return $this->belongsTo(BrikOwner::class, 'brik_owner_id');
    }

    protected static function booted()
    {
        static::deleted(function ($record) {

            CashWalletTransaction::where('brik_annual_maintanance_id', $record->id)->delete();

            $owner = BrikOwner::find($record->brik_owner_id);

            if($owner)
            {
                $sum = CashWalletTransaction::where('client_id', $owner->owner_id)->sum('signed_amount');
                $upd = Client::find($owner->owner_id);
                $upd->wallet_amount = $sum;
                $upd->save();
            }

        });
    }


}
