<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BrikInstallment extends Model
{
    protected $fillable = ['installment', 'installment_amount', 'due_date', 'installment_referal_discount','interest_on_installment', 'amount_paid', 'balance_amount','installment_paid',	'paid_date', 'brik_owner_id', 'payment_plan_id', 'active','payable_amount'];

    public function paymentPlan()
    {
        return $this->belongsTo(BrikPaymentmyplan::class, 'payment_plan_id');
    }

    public function payments()
    {
        return $this->hasMany(BrikInstallmentPayment::class, 'brik_installment_id');
    }

    protected static function booted()
    {
        static::deleted(function ($record) {

			CashWalletTransaction::where('brik_installment_id', $record->id)->delete();

            $paymentplan = BrikPaymentmyplan::find($record->payment_plan_id);

            if($paymentplan)
            {
                $owner = BrikOwner::find($paymentplan->brik_owner_id);

                if($owner)
                {
                    $sum = CashWalletTransaction::where('client_id', $owner->owner_id)->sum('signed_amount');
                    $upd = Client::find($owner->owner_id);
                    $upd->wallet_amount = $sum;
                    $upd->save();
                }
            }

        });
    }


}
