<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BrikProject extends Model
{
    protected $fillable = ['project_name','invest_description','rent_description','pets_allowed','address','state_id', 'city_id', 'pin','project_manager_id','lat','lng','cancellation_policy_id','house_rules_id','pets_friendly_id','safety_and_property_id'];

    public function state()
    {
        return $this->belongsTo(BrikState::class, 'state_id');
    }

    public function city()
    {
        return $this->belongsTo(BrikCity::class, 'city_id');
    }

    public function projectManager()
    {
        return $this->belongsTo(BrikManager::class, 'project_manager_id');
    }

    public function houseRule()
    {
        return $this->belongsTo(BrikHouserule::class, 'house_rules_id');
    }

    public function cancellationPolicy()
    {
        return $this->belongsTo(BrikCancellationPolicy::class, 'cancellation_policy_id');
    }

    public function safetyAndProperty()
    {
        return $this->belongsTo(BrikSafetyandproperty::class, 'safety_and_property_id');
    }

    public function petsFriendly()
    {
        return $this->belongsTo(BrikPetsfriendly::class, 'pets_friendly_id');
    }

    public function briks() 
    {
        return $this->hasMany(BrikBrik::class, 'brik_project_id'); 
    }

    public function brikunits() 
    {
        return $this->hasMany(BrikUnit::class, 'project_id'); 
    }

    public function nearbyPlaces() 
    {
        return $this->hasMany(BrikNearbyPlace::class, 'brik_project_id'); 
    }

    public function childRecordCounts()
    {
        return $this->hasMany(BrikBrik::class, 'brik_project_id')->count() + 
        $this->hasMany(BrikUnit::class, 'project_id')->count();
    }

    //For investment Portal

    public function investment_detail()
    {
        return $this->hasOne(InvestPropertyDetail::class, 'brik_project_id');
    }
}
