<?php

namespace App\Models;

use App\Observers\BrikUnitObserver;
use Illuminate\Database\Eloquent\Model;


class BrikUnit extends Model
{
    protected $fillable = ['project_id','spv_id','brik_id','booking_portal_display_name','rent_description','ru_property_id','property_area', 'brik_value', 'capital_gain', 'irr', 'pe_ratio', 'per_night_inr', 'per_night_coin', 'total_coins_per_brik','rent_cover_image','rent_gallery_images','invest_cover_image','invest_gallery_images','unit_name','unit_number','city_id','adults_capacity',	'children_capacity','infent_capacity','pet_capacity','possession','date_of_possession','rent_active','invest_active','property_video','property_view','gst_percent', 'managed_property','newly_launched', 'view_360','rating','allotment_letter_file','registry_file','go_live_date'];

    protected $casts = [
        'invest_gallery_images' => 'json',
        'rent_gallery_images' => 'json',
    ];
	
    public function project()
    {
        return $this->belongsTo(BrikProject::class, 'project_id');
    }

    public function brik()
    {
        return $this->belongsTo(BrikBrik::class, 'brik_id');
    }

    public function unitRatings()
    {
        return $this->hasMany(BrikUnitRating::class, 'brik_unit_id');
    }

    public function spv()
    {
        return $this->belongsTo(Spv::class, 'spv_id');
    }

    public function owners()
    {
       return $this->hasMany(BrikOwner::class, 'brik_unit_id');
    }

    public function childRecordCounts()
    {
        return $this->hasMany(BrikOwner::class, 'brik_unit_id')->count();
    }
}
