<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ReferralInsentive extends Model
{
    protected $fillable = ['brik_owner_id', 'referrer_id', 'amount', 'remark'];

    public function brik_owner()
    {
        return $this->belongsTo(BrikOwner::class, 'brik_owner_id');
    }

    public function referrer()
    {
        return $this->belongsTo(Client::class, 'referrer_id');
    }

    protected static function booted()
    {
        static::deleted(function ($record) {

            CashWalletTransaction::where('referral_insentive_id', $record->id)->delete();

            $sum = CashWalletTransaction::where('client_id', $record->referrer_id)->sum('signed_amount');
            $upd = Client::find($record->referrer_id);
            $upd->wallet_amount = $sum;
            $upd->save();
            
        });
    }
}
