<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RentHeaderSetting extends Model
{
    protected $fillable = ['name','title','type','image','carousel_images','video','active'];

    protected $casts = [
        'carousel_images' => 'json',
    ];

    protected static function booted()
    {
        static::created(function ($record) {
            if($record->active){
                RentHeaderSetting::where('id', '!=', $record->id)->update(['active' => 0]);
             }
        });

        static::updated(function ($record) {
            if($record->active){
                RentHeaderSetting::where('id', '!=', $record->id)->update(['active' => 0]);
             }
        });
    }
}
