<!DOCTYPE html>
<html lang="en">
  <head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title>Investment incomplete Booking Alert</title>
    <style media="all" type="text/css">
      /* -------------------------------------
    GLOBAL RESETS
------------------------------------- */

      body {
        font-family: Helvetica, sans-serif;
        -webkit-font-smoothing: antialiased;
        font-size: 16px;
        line-height: 1.3;
        -ms-text-size-adjust: 100%;
        -webkit-text-size-adjust: 100%;
      }

      table {
        border-collapse: separate;
        mso-table-lspace: 0pt;
        mso-table-rspace: 0pt;
        width: 100%;
      }

      table td {
        font-family: Helvetica, sans-serif;
        font-size: 16px;
        vertical-align: top;
      }
      /* -------------------------------------
    BODY & CONTAINER
------------------------------------- */

      body {
        background-color: #f4f5f6;
        margin: 0;
        padding: 0;
      }

      .body {
        background-color: #f4f5f6;
        width: 100%;
      }

      .container {
        margin: 0 auto !important;
        max-width: 900px;
        padding: 0;
        padding-top: 24px;
        width: 900px;
      }

      .content {
        box-sizing: border-box;
        display: block;
        margin: 0 auto;
        max-width: 900px;
        padding: 0;
      }
      /* -------------------------------------
    HEADER, FOOTER, MAIN
------------------------------------- */

      .main {
        background: #ffffff;
        border: 1px solid #eaebed;
        border-radius: 16px;
        width: 100%;
      }

      .wrapper {
        box-sizing: border-box;
        padding: 24px;
      }

      .footer {
        clear: both;
        padding-top: 24px;
        text-align: center;
        width: 100%;
      }

      .footer td,
      .footer p,
      .footer span,
      .footer a {
        color: #9a9ea6;
        font-size: 16px;
        text-align: center;
      }
      /* -------------------------------------
    TYPOGRAPHY
------------------------------------- */

      p {
        font-family: Helvetica, sans-serif;
        font-size: 16px;
        font-weight: normal;
        margin: 0;
        margin-bottom: 16px;
      }

      a {
        color: #0867ec;
        text-decoration: underline;
      }
      /* -------------------------------------
    BUTTONS
------------------------------------- */

      .btn {
        box-sizing: border-box;
        min-width: 100% !important;
        width: 100%;
      }

      .btn > tbody > tr > td {
        padding-bottom: 16px;
      }

      .btn table {
        width: auto;
      }

      .btn table td {
        background-color: #ffffff;
        border-radius: 4px;
        text-align: center;
      }

      .btn a {
        background-color: #ffffff;
        border: solid 2px #0867ec;
        border-radius: 4px;
        box-sizing: border-box;
        color: #0867ec;
        cursor: pointer;
        display: inline-block;
        font-size: 16px;
        font-weight: bold;
        margin: 0;
        padding: 12px 24px;
        text-decoration: none;
        text-transform: capitalize;
      }

      .btn-primary table td {
        background-color: #0867ec;
      }

      .btn-primary a {
        background-color: #0867ec;
        border-color: #0867ec;
        color: #ffffff;
      }

      @media all {
        .btn-primary table td:hover {
          background-color: #ec0867 !important;
        }
        .btn-primary a:hover {
          background-color: #ec0867 !important;
          border-color: #ec0867 !important;
        }
      }

      /* -------------------------------------
    OTHER STYLES THAT MIGHT BE USEFUL
------------------------------------- */

      .last {
        margin-bottom: 0;
      }

      .first {
        margin-top: 0;
      }

      .align-center {
        text-align: center;
      }

      .align-right {
        text-align: right;
      }

      .align-left {
        text-align: left;
      }

      .text-link {
        color: #0867ec !important;
        text-decoration: underline !important;
      }

      .clear {
        clear: both;
      }

      .mt0 {
        margin-top: 0;
      }

      .mb0 {
        margin-bottom: 0;
      }

      .preheader {
        color: transparent;
        display: none;
        height: 0;
        max-height: 0;
        max-width: 0;
        opacity: 0;
        overflow: hidden;
        mso-hide: all;
        visibility: hidden;
        width: 0;
      }

      .powered-by a {
        text-decoration: none;
      }

      /* -------------------------------------
    RESPONSIVE AND MOBILE FRIENDLY STYLES
------------------------------------- */

      @media only screen and (max-width: 640px) {
        .main p,
        .main td,
        .main span {
          font-size: 16px !important;
        }
        .wrapper {
          padding: 8px !important;
        }
        .content {
          padding: 0 !important;
        }
        .container {
          padding: 0 !important;
          padding-top: 8px !important;
          width: 100% !important;
        }
        .main {
          border-left-width: 0 !important;
          border-radius: 0 !important;
          border-right-width: 0 !important;
        }
        .btn table {
          max-width: 100% !important;
          width: 100% !important;
        }
        .btn a {
          font-size: 16px !important;
          max-width: 100% !important;
          width: 100% !important;
        }
      }
      /* -------------------------------------
    PRESERVE THESE STYLES IN THE HEAD
------------------------------------- */

      @media all {
        .ExternalClass {
          width: 100%;
        }
        .ExternalClass,
        .ExternalClass p,
        .ExternalClass span,
        .ExternalClass font,
        .ExternalClass td,
        .ExternalClass div {
          line-height: 100%;
        }
        .apple-link a {
          color: inherit !important;
          font-family: inherit !important;
          font-size: inherit !important;
          font-weight: inherit !important;
          line-height: inherit !important;
          text-decoration: none !important;
        }
        #MessageViewBody a {
          color: inherit;
          text-decoration: none;
          font-size: inherit;
          font-family: inherit;
          font-weight: inherit;
          line-height: inherit;
        }
      }
    </style>
  </head>
  <body>
    <table
      role="presentation"
      border="0"
      cellpadding="0"
      cellspacing="0"
      class="body"
    >
      <tr>
        <td>&nbsp;</td>
        <td class="container">
          <div class="content">
            <!-- START CENTERED WHITE CONTAINER -->

            <table
              role="presentation"
              border="0"
              cellpadding="0"
              cellspacing="0"
              class="main"
            >
              <!-- START MAIN CONTENT AREA -->
              <tr>
                <td class="wrapper">
                  <div style="padding-bottom: .4rem; text-align: center;">
                    <!-- <img src="" alt=""> -->
                    <span style="font-weight: 800;">BRIK itt</span>
                  </div>
                  <p>Dear Team,</p>
                  <p>The following client initiated a booking on our portal but failed in the payment process. Kindly reach out to them for assistance or follow-up.</p>

                  <h4><u>Details</u></h4>
                  {{-- <table>
                    <tr>
                        <th>Property</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Address</th>
                    </tr>

                    @foreach($incomplte_bookings as $invest_booking)
                    <tr>
                      <td>
                        {{$invest_booking->invest_property_detail ? $invest_booking->invest_property_detail->invest_portal_display_name: ''}}
                      </td>
                      <td>{{$invest_booking->name}}</td>
                      <td>{{$invest_booking->email}}</td>
                      <td>{{$invest_booking->country_code}} {{$invest_booking->phone}}</td>
                      <td>{{$invest_booking->city}} ( {{$invest_booking->state}} ) PIN - {{$invest_booking->pin}}</td>
                    </tr>
                    @endforeach
                   </table> --}}

                   <table style="width:100%; border-collapse:collapse; border:1px solid #333; font-family: Arial, sans-serif;">

  <thead>
    <tr>
      <th style="border:1px solid #333; padding:8px; text-align:left; background:#f2f2f2;">Property</th>
      <th style="border:1px solid #333; padding:8px; text-align:left; background:#f2f2f2;">Name</th>
      <th style="border:1px solid #333; padding:8px; text-align:left; background:#f2f2f2;">Email</th>
      <th style="border:1px solid #333; padding:8px; text-align:left; background:#f2f2f2;">Phone</th>
      <th style="border:1px solid #333; padding:8px; text-align:left; background:#f2f2f2;">Address</th>
    </tr>
  </thead>
  <tbody>
    @foreach($incomplte_bookings as $invest_booking)

    <tr>
      <td style="border:1px solid #333; padding:8px;"> {{$invest_booking->invest_property_detail ? $invest_booking->invest_property_detail->invest_portal_display_name: ''}}</td>
      <td style="border:1px solid #333; padding:8px;">{{$invest_booking->name}}</td>
      <td style="border:1px solid #333; padding:8px;">{{$invest_booking->email}}</td>
      <td style="border:1px solid #333; padding:8px;">{{$invest_booking->country_code}} {{$invest_booking->phone}}</td>
      <td style="border:1px solid #333; padding:8px;">{{$invest_booking->city}} ( {{$invest_booking->state}} )</td>
    </tr>

    @endforeach

  </tbody>

</table>
                </td>
              </tr>
              <!-- END MAIN CONTENT AREA -->
            </table>

            <!-- START FOOTER -->
            <div class="footer">
              <table
                role="presentation"
                border="0"
                cellpadding="0"
                cellspacing="0"
              >
                <tr>
                  <td class="content-block">
                    <span>
                      BRIK itt Proptech Pvt.Ltd.
                    </span>
                    <br />
                    <span class="apple-link"
                      >8 Flat-204 Tata Rio De Goa Near Mes College Dabolim-403726</span
                    >
                    <br />
                    Our Email
                    <a href="mailto:reservations@brikitt.com">reservations@brikitt.com</a>.
                  </td>
                </tr>
                <tr>
                  <td class="content-block powered-by">
                    Phone <a href="tel:9219965827">+91 9219965827</a>
                    <!-- <br />
                    <span>
                      BRIK itt Proptech Pvt.Ltd.
                    </span> -->
                  </td>
                </tr>
              </table>
            </div>

            <!-- END FOOTER -->

            <!-- END CENTERED WHITE CONTAINER -->
          </div>
        </td>
        <td>&nbsp;</td>
      </tr>
    </table>
  </body>
</html>
