<table>
    <thead>
        <tr>
            <th>S.NO.</th>
			<th>ID</th>
            <th>BRIK OWNER</th>
            <th>UNIT NUMBER</th>
            <th>PROJECT</th>
            <th>SPV</th>
            <th>SPV ACCOUNT</th>
            <th>IFSC</th>
            <th>PAN CARD NO.</th>
            <th>CIN NO.</th>
            <th>BRIK VALUE</th>
            <th>INVESTMENT AMOUNT</th>
            <th>BOOKING AMOUNT PAID</th>
            <th>INSTALLMENTS</th>
            <th>TOTAL INSTALLMENT PAID</th>
            <th>TOTAL INSTALLMENT PENDING</th>
            <th>DISCOUNT ON BRIK</th>
            <th>COINS</th>
            <th>REFERRAL DISCOUNT</th>
        </tr>
    </thead>
    <tbody> 

                @foreach($records as $record)

                <tr>
                    <th>{{$loop->iteration}}</th>
					<th>{{$record->id}}</th>
                    <th>{{$record->owner ? $record->owner->full_name : ''}}</th>
                    <th>{{$record->brik_unit ? $record->brik_unit->unit_number : ''}}</th>
                    <th>{{$record->brik_unit ? ($record->brik_unit->project ? $record->brik_unit->project->project_name : '') : ''}}</th>
                    <th>{{$record->brik_unit ? ($record->brik_unit->spv ? $record->brik_unit->spv->spv_name : '') : ''}}</th>
                    <th>{{$record->brik_unit ? ($record->brik_unit->spv ? (string)$record->brik_unit->spv->bank_account_number : '') : ''}}</th>
                    <th>{{$record->brik_unit ? ($record->brik_unit->spv ? $record->brik_unit->spv->ifsc_code : '') : ''}}</th>
                    <th>{{$record->brik_unit ? ($record->brik_unit->spv ? $record->brik_unit->spv->pan_card : '') : ''}}</th>
                    <th>{{$record->brik_unit ? ($record->brik_unit->spv ? $record->brik_unit->spv->coi_number : '') : ''}}</th>
                    <th>{{$record->brik_unit ? $record->brik_unit->brik_value : ''}}</th>
                    <th>{{$record->payment_plan ? $record->payment_plan->invested_amount : ''}}</th>
                    <th>{{$record->payment_plan ? $record->payment_plan->booking_amount : ''}}</th>
                    <th>{{$record->payment_plan ? ( count($record->payment_plan->installments) > 0 ? '(Total '.count($record->payment_plan->installments).' Installments) Amount: '.$record->payment_plan->installments->sum('payable_amount') : '') : ''}}</th>
                    <th>{{$record->payment_plan ? ( count($record->payment_plan->installments) > 0 ? $record->payment_plan->installments->sum('amount_paid') : '') : ''}}</th>
                    <th>{{$record->payment_plan ? ( count($record->payment_plan->installments) > 0 ? $record->payment_plan->installments->sum('balance_amount') : '') : ''}}</th>
                    <th>{{$record->payment_plan ? $record->payment_plan->discount_brik : ''}}</th>
                    <th>{{$record->owner ? $record->owner->coins : ''}}</th>
                    <th>{{$record->owner ? $record->owner->wallet_amount : ''}}</th>
                </tr>

                @endforeach

    </tbody>
</table>
