<!DOCTYPE html>
<html lang="en">
  <head>
   
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>BRIKitt Tax-Invoice</title>
  </head>
  <body style="font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;">
    <!-- 1st Table ----------- -->
    <table style="width: 100%;">
      <tr>
        <h2 style="text-align: center">Tax Invoice</h2>
      </tr>
    </table>

    <!-- 2nd Table ------- -->
    <table style="width: 100%; border-collapse: collapse; border: 1px solid #110e1b">
      <tr>
        <td style="padding: 0.3rem">
          <b style="display: block; font-size: 1.8rem; padding-bottom: 0.2rem"
            >BRIKitt Proptech Private Limited</b
          >
          <small
            >929-181 Office No. 707 Kamlabad Badhauli Mauhiddinpur Sitapur Road
            Lucknow</small
          >
        </td>
      </tr>
      <tr>
        <td>
         <table style="width: 100%">
          <tr>
            <td>
              <small>
                <span>Phone: </span>
                <a
                  href="tel:9517277735"
                  style="color: black; text-decoration: none; font-weight: 600"
                  >9517277735</a
                >
              </small>
            </td>
            <td>
              <small>
                <span>Email: </span>
                <a
                  href="mailto:info@brikitt.com"
                  style="color: black; text-decoration: none; font-weight: 600"
                  >info@brikitt.com</a
                >
              </small>
            </td>
          </tr>
          <tr>
            <td>
              <small>
                <span>GSTIN: </span>
                <span style="font-weight: 600">09AAKCB2571Q1Z0</span>
              </small>
            </td>
            <td>
              <small>
                <span>State: </span>
                <span style="font-weight: 600">09-Uttar Pradesh</span>
              </small>
            </td>
          </tr>
         </table>
         </td>
      </tr>
    </table>
    
    <table style="width: 100%; border-collapse: collapse; border: 1px solid #110e1b;border-top: none;">
      <tr style="border-top: none;border-bottom: 1px solid">
        <td>
          <small>
            <b>Bill To:</b>
          </small>
        </td>
        <td>
          <small>
            <b>Invoice Details:</b>
          </small>
        </td>
      </tr>
      <tr>
        <td>
          <small
            style="display: block; padding-bottom: 0.3rem; font-weight: 600"
          >
            {{$client["name"]}}
          </small>
          <small
            style="display: flex; gap: 0.4rem; justify-content: space-between"
          >
            <span>
              <span>Contact No: </span>
              <span style="font-weight: 600">{{$client["phone"]}}</span>
            </span><br>
            <span>
              <span>State: </span>
              <span style="font-weight: 600">{{$client["state"]}}</span>
            </span>
          </small>
        </td>
        <td>
          <small style="display: block; padding-bottom: 0.3rem">
            <span>No: </span>
            <span style="font-weight: 600">{{$booking_req->id}}</span>
          </small>
          <small style="display: block; padding-bottom: 0.3rem">
            <span>Date: </span>
            <span style="font-weight: 600">{{date("d/m/Y", strtotime($booking_req->created_at))}}</span>
          </small>
          <small style="display: block; padding-bottom: 0.3rem">
            <span>Place Of Supply: </span>
            <span style="font-weight: 600">{{$client["state_code"]}}{{$client["state"]}}</span>
          </small>
        </td>
      </tr>
    </table>

    <!-- 3rd Table ------- -->
    <table
      style="
        width: 100%;
        border-collapse: collapse;
        margin-top: 0.5rem;
        border: 1px solid #110e1b;
        font-size: 12px;
        text-align: left;
      "
    >
      <thead>
        <tr>
          <th style="padding: 0.5rem 0.3rem; border: 1px solid black"></th>
          <th
            style="
              padding: 0.5rem 0.3rem;
              border: 1px solid black;
              width: 160px;
            "
          >
            Item Name
          </th>
          <th style="padding: 0.5rem 0.3rem; border: 1px solid black">
            HSN/SAC
          </th>
          <th
            style="padding: 0.5rem 0.3rem; border: 1px solid black; width: 70px"
          >
            Arrival
          </th>
          <th style="padding: 0.5rem 0.3rem; border: 1px solid black">
            Departure
          </th>
          <th style="padding: 0.5rem 0.3rem; border: 1px solid black">Night</th>
          <th style="padding: 0.5rem 0.3rem; border: 1px solid black">
            Unit No.
          </th>
          <th style="padding: 0.5rem 0.3rem; border: 1px solid black">
            Quantity
          </th>
          <th style="padding: 0.5rem 0.3rem; border: 1px solid black">
            Price/Unit(₹)
          </th>
          <th style="padding: 0.5rem 0.3rem; border: 1px solid black">
            GST(₹)
          </th>
          <th style="padding: 0.5rem 0.3rem; border: 1px solid black">
            Amount(₹)
          </th>
        </tr>
      </thead>
	  

      <tbody>
        @php $i = 1; @endphp
        @foreach($booking_req->bookings as $bookingrcd)
		
				<?php
				$gst_percent = 0;
				$payable_value = $bookingrcd->booking_cost_in_rupee ? $bookingrcd->booking_cost_in_rupee : 0;
				$gst_value = $bookingrcd->gst_amount ? $bookingrcd->gst_amount : 0;
				
				if($payable_value > 0 && $gst_value > 0){
					$gst_percent = (($gst_value * 100)/$payable_value);
				}
				
				?>
        @if($bookingrcd->pay_by == 'Coin')
        <tr>
          <td style="padding: 0.5rem 0.3rem; border: 1px solid black">{{$i}}</td>
          <td style="padding: 0.5rem 0.3rem; border: 1px solid black">
            Stay at-{{$bookingrcd->brik_unit->booking_portal_display_name}}
          </td>
          <td style="padding: 0.5rem 0.3rem; border: 1px solid black">1</td>
          <td style="padding: 0.5rem 0.3rem; border: 1px solid black">
            {{date("d M y", strtotime($bookingrcd->date_check_in))}}
          </td>
          <td style="padding: 0.5rem 0.3rem; border: 1px solid black">
            {{date("d M y", strtotime($bookingrcd->date_check_out))}}
          </td>
          <td style="padding: 0.5rem 0.3rem; border: 1px solid black">{{$bookingrcd->booking_night_counts}}</td>
          <td style="padding: 0.5rem 0.3rem; border: 1px solid black">{{$bookingrcd->brik_unit->unit_number}}</td>
          <td style="padding: 0.5rem 0.3rem; border: 1px solid black"></td>
          <td
            style="
              padding: 0.5rem 0.3rem;
              border: 1px solid black;
              text-align: right;
            "
          >
            ₹ {{$bookingrcd->booking_cost_in_rupee ? $bookingrcd->booking_cost_in_rupee : 0}}
          </td>
          <td
            style="
              padding: 0.5rem 0.3rem;
              border: 1px solid black;
              text-align: right;
            "
          >
            ₹ {{ $bookingrcd->gst_amount ? $bookingrcd->gst_amount : 0 }} ({{$gst_percent}}%) 
          </td>
          <td
            style="
              /* padding: 0.5rem 0.3rem; */
              border: 1px solid black;
              text-align: right;
            "
          >
            ₹ {{$bookingrcd->net_payable_amount ? $bookingrcd->net_payable_amount : 0}}
          </td>
        </tr>
        
        @elseif($bookingrcd->pay_by == 'Amount')

            @foreach($bookingrcd->details as $detail)
            <tr>
              <td style="padding: 0.5rem 0.3rem; border: 1px solid black">{{$i}}</td>
              <td style="padding: 0.5rem 0.3rem; border: 1px solid black">
                Stay at-{{$bookingrcd->brik_unit->booking_portal_display_name}}
              </td>
              <td style="padding: 0.5rem 0.3rem; border: 1px solid black">1</td>
              <td style="padding: 0.5rem 0.3rem; border: 1px solid black">
                {{date("d M y", strtotime($detail->from_date))}}
              </td>
              <td style="padding: 0.5rem 0.3rem; border: 1px solid black">
                {{date("d M y", strtotime($detail->to_date))}}
              </td>
              <td style="padding: 0.5rem 0.3rem; border: 1px solid black">{{$detail->nights}}</td>
              <td style="padding: 0.5rem 0.3rem; border: 1px solid black">{{$bookingrcd->brik_unit->unit_number}}</td>
              <td style="padding: 0.5rem 0.3rem; border: 1px solid black"></td>
              <td
                style="
                  padding: 0.5rem 0.3rem;
                  border: 1px solid black;
                  text-align: right;
                "
              >
                ₹ {{$detail->price ? $detail->price : 0}}
              </td>
              <td
                style="
                  padding: 0.5rem 0.3rem;
                  border: 1px solid black;
                  text-align: right;
                "
              >
                @php $gst_amt =  $detail->booking_price ? ($detail->booking_price * ($gst_percent/100)) : 0; @endphp
                ₹ {{$gst_amt}} ({{$gst_percent}}%)
              </td>
              <td
                style="
                  /* padding: 0.5rem 0.3rem; */
                  border: 1px solid black;
                  text-align: right;
                "
              >
                ₹ {{$detail->booking_price ? $detail->booking_price + $gst_amt : 0}}
              </td>
            </tr>
             @php $i++; @endphp
            @endforeach

        @endif
          @php $i++; @endphp
      @endforeach
      </tbody>
      <tfoot>
        <tr>
          <th></th>
          <th
            colspan="8"
            style="
              padding: 0.1rem 0.3rem;
              border: 1px solid black;
              text-align: left;
            "
          >
            Total
          </th>
          <th
            style="
              padding: 0.1rem 0.3rem;
              border: 1px solid black;
              text-align: right;
            "
          >
            ₹ {{$booking->gst_amount ? $booking->gst_amount : 0}}
          </th>
          <th
            style="
              padding: 0.1rem 0.3rem;
              border: 1px solid black;
              text-align: right;
            "
          >
            ₹ {{$booking->net_payable_amount ? $booking->net_payable_amount : 0}}
          </th>
        </tr>

        <!-- 3rd TABLE PARTITION ---------------- -->
        <!-- 1st row  -->
        <tr>
          <th
            colspan="8"
            style="
              padding: 0.1rem 0.3rem;
              border-top: 1px solid black;
              border-bottom: 1px solid black;
              text-align: left;
            "
          >
            Tax Summary:
          </th>
          <td style="border-left: 1px solid black; padding: 0.1rem 0.3rem">
            Sub Total
          </td>
          <td>:</td>
          <td style="text-align: right; padding: 0.1rem 0.3rem">₹ {{$booking->net_payable_amount ? $booking->net_payable_amount : 0}}</td>
        </tr>
        <!-- 2nd row  -->
        <tr>
          <th
            colspan="2"
            rowspan="2"
            style="border: 1px solid black; text-align: center"
          >
            HSN/ SAC
          </th>
          <th
            colspan="1"
            rowspan="2"
            style="border: 1px solid black; text-align: center"
          >
            Taxable amount (₹)
          </th>
          <td
            colspan="2"
            style="
              text-align: center;
              border: 1px solid black;
              text-align: center;
            "
          >
            IGST
          </td>
          <td
            colspan="3"
            rowspan="2"
            style="border: 1px solid black; text-align: center"
          >
            Total Tax (₹)
          </td>
          <td style="padding: 0.1rem 0.3rem">Round Off</td>
          <td>:</td>
          <td style="padding: 0.1rem 0.3rem; text-align: right">- ₹ 0</td>
        </tr>
        <!-- 3nd row  -->
        <tr>
          <th
            style="
              padding: 0.1rem 0.3rem;
              border: 1px solid black;
              text-align: center;
            "
          >
            Rate (%)
          </th>
          <th
            style="
              padding: 0.1rem 0.3rem;
              border: 1px solid black;
              text-align: center;
            "
          >
            Amt (₹)
          </th>
          <th style="padding: 0.1rem 0.3rem; border-top: 1px solid black">
            Total:
          </th>
          <th style="border-top: 1px solid black">:</th>
          <th
            style="
              padding: 0.1rem 0.3rem;
              border-top: 1px solid black;
              text-align: right;
            "
          >
            ₹ {{$booking->net_payable_amount ? $booking->net_payable_amount : 0}}
          </th>
        </tr>

        <!-- 4th row -->
        <tr>
          <td
            colspan="2"
            style="border: 1px solid black; text-align: center"
          ></td>
          <td
            style="
              padding: 0.1rem 0.3rem;
              border: 1px solid black;
              text-align: right;
            "
          >
            {{$booking->payable_amount ? $booking->payable_amount : 0}}
          </td>
          <td
            style="
              padding: 0.1rem 0.3rem;
              border: 1px solid black;
              text-align: right;
            "
          >
		  {{$gst_percent}}
          </td>
          <td
            style="
              padding: 0.1rem 0.3rem;
              border: 1px solid black;
              text-align: right;
            "
          >
            {{$booking->gst_amount ? $booking->gst_amount : 0}}
          </td>
          <td
            colspan="3"
            style="
              padding: 0.1rem 0.3rem;
              border: 1px solid black;
              text-align: right;
            "
          >
            {{$booking->gst_amount ? $booking->gst_amount : 0}}
          </td>
          <th
            colspan="4"
            style="
              padding: 0.1rem 0.3rem;
              border: 1px solid black;
              text-align: left;
            "
          >
            Invoice Amount in Words:
          </th>
        </tr>

        <!-- 5th row -->
        <tr>
          <th colspan="2" style="border: 1px solid black; text-align: right">
            Total
          </th>
          <th
            style="
              padding: 0.1rem 0.3rem;
              border: 1px solid black;
              text-align: right;
            "
          >
            {{$booking->payable_amount ? $booking->payable_amount : 0}}
          </th>
          <th
            style="
              padding: 0.1rem 0.3rem;
              border: 1px solid black;
              text-align: right;
            "
          ></th>
          <th
            style="
              padding: 0.1rem 0.3rem;
              border: 1px solid black;
              text-align: right;
            "
          >
            {{$booking->gst_amount ? $booking->gst_amount : 0}}
          </th>
          <th
            colspan="3"
            style="
              padding: 0.1rem 0.3rem;
              border: 1px solid black;
              text-align: right;
            "
          >
            {{$booking->gst_amount ? $booking->gst_amount : 0}}
          </th>
          <td
            colspan="4"
            style="
              padding: 0.1rem 0.3rem;
              border: 1px solid black;
              text-align: left;
            "
          >
            {{-- Five Thousand Six Hundred Rupees only --}}
          </td>
        </tr>
		
		<?php
		
		  $net_payable_amount = $booking->net_payable_amount ? $booking->net_payable_amount : 0;
		  if($booking->booking_status == 'Active'){
			  $received_amt = $net_payable_amount;
			  $balance_amt = 0;
		  }else{
			  $received_amt = 0;
			  $balance_amt = $net_payable_amount;
		  }
		  
		?>

        <!-- 6th row -->
        <tr>
          <td colspan="8"></td>
          <td style="border-left: 1px solid black; padding: 0.1rem 0.3rem">
            Received
          </td>
          <td style="padding: 0.1rem 0.3rem">:</td>
          <td style="padding: 0.1rem 0.3rem; text-align: right">₹ {{$received_amt}}</td>
        </tr>
        <!-- 7th row -->
        <tr>
          <td colspan="8"></td>
          <td style="border-left: 1px solid black; padding: 0.1rem 0.3rem">
            Balance
          </td>
          <td style="padding: 0.1rem 0.3rem">:</td>
          <td style="padding: 0.1rem 0.3rem; text-align: right">₹ {{$balance_amt}}</td>
        </tr>
      </tfoot>
    </table>

    <!-- 4th Table --------  -->
    <table
    style="
        width: 100%;
        border-collapse: collapse;
        margin-top: 0.5rem;
        font-size: 12px;
        text-align: left;
      "
    >
      <tr>
        <th colspan="6" style="border: 1px solid black; padding: 0.1rem 0.3rem">
          Terms & Conditions:
        </th>
      </tr>

      <tr>
        <td colspan="6" style="border: 1px solid black; padding: 0.1rem 0.3rem">
          Thanks for doing business with us!
        </td>
      </tr>

      <tr>
        <td colspan="6"></td>
        <th style="border: 1px solid black; padding: 0.1rem 0.3rem">
          For BRIKitt Proptech Private Limited:
        </th>
      </tr>
      <tr>
        <td colspan="6"></td>
        <td
          rowspan="5"
          style="
            padding: 0.1rem 0.3rem;
            border: 1px solid black;
            text-align: center;
          "
        >
          <div style="padding-top: 3.5rem">Authorized Signatory</div>
        </td>
      </tr>
    </table>
  </body>
</html>
