<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\TestController;
use App\Http\Controllers\Api\Auth\AuthController;
use App\Http\Controllers\Api\Invest\BlogController;
use App\Http\Controllers\Api\Booking\BrikController;
use App\Http\Controllers\Api\Utility\CityController;
use App\Http\Controllers\Api\Utility\MetadataController;
use App\Http\Controllers\Api\Booking\CouponController;
use App\Http\Controllers\Api\Booking\BookingController;
use App\Http\Controllers\Api\Booking\CommentController;
use App\Http\Controllers\Api\Booking\SettingController;
use App\Http\Controllers\Api\Invest\PropertyController;
use App\Http\Controllers\Api\Owner\OwnerBrikController;
use App\Http\Controllers\Api\Booking\WishlistController;
use App\Http\Controllers\Api\Owner\OwnerProfileController;
use App\Http\Controllers\Api\Owner\OwnerScheduleController;
use App\Http\Controllers\Api\Booking\BookingEmailController;
use App\Http\Controllers\Api\Invest\InvestEmailsController;
use App\Http\Controllers\Api\Owner\OwnerDocumentsController;
use App\Http\Controllers\Api\Invest\PropertyBookingController;
use App\Http\Controllers\Api\Owner\OwnerBrikCoOwnerController;
use App\Http\Controllers\Api\Owner\OwnerBrikBuyPaymentController;
use App\Http\Controllers\Api\Owner\OwnerInstallmentPaymentController;
use App\Http\Controllers\Api\Owner\OwnerAnnualMaintanancePaymentController;
use App\Http\Controllers\Api\Owner\OwnerGrowthController;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:api');

Route::prefix('v1')->group(function () {

    /* Authentication */
    Route::post('send-otp', [AuthController::class, 'sendotp']);
    Route::post('verify-otp', [AuthController::class, 'verifyotp']);
    Route::post('direct-login', [AuthController::class, 'directlogin']);
	Route::post('social-login', [AuthController::class, 'socialmedialogin']);

    Route::get('test', [AuthController::class, 'testingToken']);
    Route::get('rutest-owner', [TestController::class, 'owners']);
    Route::get('rutest-avl', [TestController::class, 'checkAvailibility']);
    Route::get('rutest-book', [TestController::class, 'book']);
	
	
	Route::post('seo-metadata', [MetadataController::class, 'getmetadata']);

    Route::prefix('stay')->group(function () {
        /* Utilities */
        Route::get('cities', [CityController::class, 'list']);
		Route::get('search-cities', [CityController::class, 'searchCityList']);

        Route::get('state-list', [CityController::class, 'statelist']);
        Route::get('city-list', [CityController::class, 'citylist']);
        Route::get('city-list-by-state/{state_name}', [CityController::class, 'citylistbystate']);

        /* Briks */
        Route::get('briks', [BrikController::class, 'list']);
        Route::get('briks/new', [BrikController::class, 'listnew']);
        Route::get('briks/new-all', [BrikController::class, 'listnewall']);
        Route::get('briks/highly-rated', [BrikController::class, 'highlyrated']);
        Route::get('briks/highly-rated-all', [BrikController::class, 'highlyratedall']);
        Route::get('brik/{id}', [BrikController::class, 'brikdetail']);
        Route::post('briks/filter', [BrikController::class, 'filter']);

        /* Setting */
        Route::get('setting/heading', [SettingController::class, 'heading']);
        Route::get('setting/promotion', [SettingController::class, 'promotion']);
        Route::get('setting/trusted-villas', [SettingController::class, 'trustedVillas']);
        Route::get('setting/moods', [SettingController::class, 'moods']);
        Route::get('setting/mood/brik-units/{mood_id}', [SettingController::class, 'moodunits']);

        Route::get('/brik-comments',[CommentController::class, 'index']);
		Route::get('/brik-all-comments',[CommentController::class, 'showall']);


        Route::middleware(['auth:api'])->group(function () {
			
			/* Account Remove */ 
			Route::post('account-remove', [AuthController::class, 'accountRemove']);

            /* comments */
            Route::apiResource('/comments',CommentController::class);

            Route::get('login-verify', [AuthController::class, 'verify']);
            Route::post('profile-update', [AuthController::class, 'updateprofile']);
			
			Route::post('complete-profile-update', [AuthController::class, 'updateprofilefull']); // Use With Caustion phone no, email also can update
            Route::post('profile-pic-update', [AuthController::class, 'updateprofilepic']);
            Route::delete('profile-pic-remove', [AuthController::class, 'removeprofilepic']);

            /* Coupons */
            Route::post('coupon/get-valid-coupons', [CouponController::class, 'getValidCoupons']);

            /* Wishlist */
            Route::get('wishlist/items', [WishlistController::class, 'list']);
            Route::post('wishlist/add-item', [WishlistController::class, 'additem']);
            Route::post('wishlist/remove-item', [WishlistController::class, 'removeitem']);

            /* Ratings */
            Route::get('ratings/list', [WishlistController::class, 'list']);


            /* Booking Process */
            Route::get('booked-dates/{unit_id}', [BookingController::class, 'bookedDates']);
			Route::post('booking-cost-calculate', [BookingController::class, 'bookingCostCal']);
            Route::post('pre-booking', [BookingController::class, 'preBooking']);
			Route::post('pre-booking-complementary', [BookingController::class, 'preBookingComplementary']);
			Route::post('complementary-check', [BookingController::class, 'complementaryCheck']);
            Route::post('booking', [BookingController::class, 'booking']);

            Route::post('booking-success-emails', [BookingEmailController::class, 'sendEmail']);
            Route::post('booking-cancel-emails', [BookingEmailController::class, 'sendCancelEmail']);

            Route::get('booking-history', [BookingController::class, 'bookingHistory']);
			Route::get('booking-history-detail/{booking_request_id}', [BookingController::class, 'bookingHistoryDetail']);
            Route::get('booking-past-history', [BookingController::class, 'bookingPastHistory']);
            Route::get('booking-cancel-history', [BookingController::class, 'bookingCancelHistory']);

            Route::post('booking-order-details', [BookingController::class, 'bookingOrderDetails']);

            Route::post('pre-cancel', [BookingController::class, 'preCancel']);
            Route::post('cancel', [BookingController::class, 'cancel']);
        });
    });

    Route::prefix('invest')->group(function () {

        Route::get('all-properties', [PropertyController::class, 'showall']);
        Route::get('new-properties', [PropertyController::class, 'shownewlylaunched']);
        Route::get('property-details/{project_id}', [PropertyController::class, 'showdetail']);
        Route::post('pre-payment', [PropertyBookingController::class, 'book']);
        Route::post('payment-details', [PropertyBookingController::class, 'paymentDetails']);
        Route::post('enquiry', [PropertyBookingController::class, 'enquiry']);


        Route::get('all-blogs', [BlogController::class, 'showall']);
        Route::get('blog-details/{blog_id}', [BlogController::class, 'showdetail']);
		
		Route::post('contact-us', [InvestEmailsController::class, 'contact_us']);
        Route::post('channel-partner-request', [InvestEmailsController::class, 'become_channel_partner']);
        Route::post('job-apply', [InvestEmailsController::class, 'job_apply']);
		
		Route::post('booking-success-email', [InvestEmailsController::class, 'successInvestBooking']);
        Route::post('booking-failed-email', [InvestEmailsController::class, 'failedInvestBooking']);

    });

    Route::prefix('owner')->group(function () {

        Route::middleware(['auth:api'])->group(function () {

			/* Owner Profile */
            Route::get('profile', [OwnerProfileController::class, 'getProfile']);
            Route::post('update-personal-info', [OwnerProfileController::class, 'updatePersonalInfo']);
            Route::post('update-bank-info', [OwnerProfileController::class, 'updateBankInfo']);
            Route::post('update-nominee-info', [OwnerProfileController::class, 'updateNomineeInfo']);
            Route::post('update-id-info', [OwnerProfileController::class, 'updateIdInfo']);
            Route::post('update-bank-statement', [OwnerProfileController::class, 'updateBankStatement']);
            Route::post('update-nominee-image', [OwnerProfileController::class, 'updateNomineePhoto']);
            Route::delete('remove-nominee-image', [OwnerProfileController::class, 'removeNomineePhoto']);

            Route::post('remove-id-info', [OwnerProfileController::class, 'removeIdInfo']);


            Route::get('referral-earning-log', [OwnerProfileController::class, 'referralDiscountearningLog']);

            /* Owner Briks */
            Route::get('briks', [OwnerBrikController::class, 'list']);
            Route::get('brik/{id}', [OwnerBrikController::class, 'brikdetail']);

            /* Owner Co-owners */
            Route::get('co-owners/{unit_id}', [OwnerBrikCoOwnerController::class, 'coOwners']);
            Route::post('co-owners-send-request/{unit_id}', [OwnerBrikCoOwnerController::class, 'coOwnerSendRequest']);
            Route::get('co-owners-list-requests', [OwnerBrikCoOwnerController::class, 'listCoOwnersRequest']);
            Route::patch('co-owners-request-approve/{req_id}', [OwnerBrikCoOwnerController::class, 'coOwnersRequestApproved']);
            Route::patch('co-owners-request-declined/{req_id}', [OwnerBrikCoOwnerController::class, 'coOwnersRequestDeclined']);

            /* Payments */
            Route::get('brik-booking/payments/{unit_id}', [OwnerBrikBuyPaymentController::class, 'show']);
            Route::get('brik-booking/payment-reminder/{unit_id}', [OwnerBrikBuyPaymentController::class, 'showReminder']);

            /* Installments */
            Route::get('installment/payments/{ownership_id}', [OwnerInstallmentPaymentController::class, 'show']);
            Route::get('installment/payment-reminder/{ownership_id}', [OwnerInstallmentPaymentController::class, 'showReminder']);
			Route::post('installment/pay-payment', [OwnerInstallmentPaymentController::class, 'payment']);
            Route::post('installment-payment-details', [OwnerInstallmentPaymentController::class, 'installmentPaymentDetails']);

            /* Annual Maintanance */
            Route::get('maintance/payments/{ownership_id}', [OwnerAnnualMaintanancePaymentController::class, 'show']);
            Route::get('maintance/payment-reminder/{ownership_id}', [OwnerAnnualMaintanancePaymentController::class, 'showReminder']);
			Route::post('maintance/pay-payment', [OwnerAnnualMaintanancePaymentController::class, 'payment']);
            Route::post('maintance-payment-details', [OwnerAnnualMaintanancePaymentController::class, 'maintanancePaymentDetails']);


			/* Docs */
            Route::get('docs/{unit_id}', [OwnerDocumentsController::class, 'show']);

             /* Growth */
            Route::get('growth/revenue/{unit_id}', [OwnerGrowthController::class, 'revenue']);
            Route::get('growth/growth/{unit_id}', [OwnerGrowthController::class, 'growth']);

             /* Schedule */
             Route::get('schedule/all-bookings/{unit_id}', [OwnerScheduleController::class, 'bookingAllHistory']);
             Route::get('schedule/past-bookings/{unit_id}', [OwnerScheduleController::class, 'bookingPastHistory']);
             Route::get('schedule/upcoming-bookings/{unit_id}', [OwnerScheduleController::class, 'bookingUpcomingHistory']);

             Route::get('schedule/all-bookedDates/{unit_id}/', [OwnerScheduleController::class, 'allbookedDates']);
             Route::get('schedule/past-bookedDates/{unit_id}/', [OwnerScheduleController::class, 'pastbookedDates']);
             Route::get('schedule/upcoming-bookedDates/{unit_id}/', [OwnerScheduleController::class, 'upcomingbookedDates']);

        });

    });
});
