<?php

use App\Http\Controllers\Api\Booking\BookingController;
use App\Http\Controllers\Api\Booking\RURLNMController;
use App\Http\Controllers\Api\Invest\PropertyBookingController;
use App\Http\Controllers\Api\Owner\OwnerAnnualMaintanancePaymentController;
use App\Http\Controllers\Api\Owner\OwnerInstallmentPaymentController;
use App\Http\Controllers\Api\TestController;
use App\Http\Controllers\Api\MobileAppPaymentController;
use App\Http\Controllers\ReceiptController; 
use Illuminate\Support\Facades\Route;

Route::get('/receipt/installment/{installment_id}',[ReceiptController::class, 'installment'])->name('installment.receipt'); 
Route::get('/receipt/maintenance/{amc_id}',[ReceiptController::class, 'amc'])->name('amc.receipt');
Route::get('/receipt/stay/booking/{booking_id}',[ReceiptController::class, 'rentbooking'])->name('rentbooking.receipt'); 

Route::get('/canceltest',[TestController::class, 'canceltest']);

Route::get('/demomail',[TestController::class, 'demomail']);


Route::get('/', function () {
    return redirect('/admin');
});

Route::get('/ru-rlnm-set',[RURLNMController::class, 'register'])->name('ru.rlnm.set'); 

Route::post('/ru-rlnm-handle',[RURLNMController::class, 'handle'])->name('ru.rlnm.rq');

Route::get('/booking-payment-testing',[BookingController::class, 'paymenttest']); 

Route::get('/cashfree-payment/{payment_session_id}',[MobileAppPaymentController::class, 'payment']);

// Booking Payment detail
Route::get('/booking-payment-return',[BookingController::class, 'paymentreturn'])->name('booking.payment.return');
// Installment Payment detail
Route::get('/installment-payment-return',[OwnerInstallmentPaymentController::class, 'paymentreturn'])->name('installment.payment.return');
// AMC Payment detail
Route::get('/maintenance-payment-return',[OwnerAnnualMaintanancePaymentController::class, 'paymentreturn'])->name('maintenance.payment.return');

Route::get('/invest/property-booking/payment/{order_no}',[PropertyBookingController::class, 'payment'])->name('invest.payment');

Route::post('/invest/property-booking/payment-return',[PropertyBookingController::class, 'paymentreturn'])->name('invest.paymentreturn');

Route::post('/invest/property-booking/payment-cancel',[PropertyBookingController::class, 'paymentcancel'])->name('invest.paymentcancel');

Route::get('/booking-test',[BookingController::class, 'test']); 

