<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use App\Models\BrikNearbyPlace;
use Filament\Resources\Resource;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Section;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\BrikNearbyPlaceResource\Pages;
use App\Filament\Admin\Resources\BrikNearbyPlaceResource\RelationManagers;

class BrikNearbyPlaceResource extends Resource
{
    protected static ?string $model = BrikNearbyPlace::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'BRIK';

    protected static ?string $modelLabel = 'Nearby Place';
    
    protected static ?string $pluralModelLabel = 'Nearby Places';

    protected static ?string $navigationLabel = 'Nearby Place';

    protected static ?int $navigationSort = 6;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make()->schema([

                    Select::make('brik_id')->relationship('brik', 'property_name')->required(),
                    TextInput::make('place')->required(),
                    TextInput::make('distance')->label('Distance in KM')->required()

                ])->columns(3)
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                
                TextColumn::make('brik.property_name')
                ->sortable()
                ->searchable(),

                TextColumn::make('place')
                ->sortable()
                ->searchable(),

                TextColumn::make('distance')
                ->sortable()
                ->searchable(),
                
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make(),
                ]),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBrikNearbyPlaces::route('/'),
            'create' => Pages\CreateBrikNearbyPlace::route('/create'),
            'edit' => Pages\EditBrikNearbyPlace::route('/{record}/edit'),
        ];
    }
}
